/*
 * Copyright (C) 2003 the xmms-kde team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#ifndef __XMMSKDECONFIG_H__
#define __XMMSKDECONFIG_H__

#include <config.h>

#include <kaccel.h>
#include <kcolorbutton.h>
#include <kconfig.h>
#include <kdialogbase.h>
#include <kfilemetainfo.h>
#include <kglobalaccel.h>
#include <kkeydialog.h>
#include <klocale.h>
#include <kmimetype.h>
#include <ksimpleconfig.h>
#include <kstddirs.h>
#include <ktar.h>

#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qcolordialog.h>
#include <qcolor.h>
#include <qcombobox.h>
#include <qdir.h>
#include <qfiledialog.h>
#include <qfileinfo.h>
#include <qhbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qmessagebox.h>
#include <qpixmap.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qspinbox.h>
#include <qsplitter.h>
#include <qstringlist.h>
#include <qtabwidget.h>
#include <qvbox.h>
#include <qvbuttongroup.h>
#include <qwidget.h>


#include "osdframe.h"
#include "xmms-kdedb.h"

#include "playerinterface.h"

QByteArray readFile(QString tarName, QString fileName);

class XmmsKdeConfigDialog : public KDialogBase {
  Q_OBJECT

public:

  XmmsKdeConfigDialog(QWidget *parent, QStringList themeList, 
		      KStandardDirs *dataDirs, int currentScrollMode, 
		      KGlobalAccel *globalAccel,			
		      QString currentTheme,
		      PlayerInterface::Player currentPlayer,
		      bool hideXmms,
		      bool readTags, bool underscores,
		      OSDFrame *osd,
		      XmmsKdeDB *datab,
		      XmmsKdeDBQuery *querydb);
  
  virtual ~XmmsKdeConfigDialog();
  
  QString getSelectedTheme();
  
  PlayerInterface::Player getSelectedPlayer();
  
  int getScrollMode();
  
  bool enableAccels();
  
  bool getHideXmms() {
    return minimizeXmmsPlayer->isChecked();
  }
  
  bool getReadID3Tags() {
    return readID3Tags->isChecked();
  }
  
  bool getConvertUnderscores() {
    return convertUnderscores->isChecked();
  }
    
protected:

private slots:
      
  void showTheme(int);

  void scrollModeChanged(int);
 
  void accelButtonClicked();
  void playerChanged(int);

private:
  void loadTheme(QString themeName);

  void setupThemesPage(QString currentTheme);

  void setupAccelPage();

  void setupOSDPage(OSDFrame *osd);

  void setupDBPage(XmmsKdeDB *db, XmmsKdeDBQuery *query);
  
  void setupPlayerPage(PlayerInterface::Player currentPlayer,
		       bool hideXmms, bool readTags, bool underscores);

  void addPathToDatabase(XmmsKdeDB *db, QString path);

  KStandardDirs* dDirs; 
  QStringList    tlist; 
  QStringList*   nameList; 
  QListBox*      themeListBox; 
  QString        theme;
  int            scrollMode;
  QLabel*        imageLabel;
  QPixmap*       noScreen;
  KGlobalAccel*  accel;
  QCheckBox*     accelBox;
  QButtonGroup*  playerGroup;

  QCheckBox *minimizeXmmsPlayer;

  QCheckBox *readID3Tags;
  QCheckBox *convertUnderscores;

  PlayerInterface::Player selectedPlayer;

  QLineEdit *pathEdit;
  QListBox *pathList;

  StatusLabel *dbStatusLabel;

  QVButtonGroup *dbQueryPopup;
};

#endif

