# EMACS: -*- rpm-spec -*-
# Note that this is NOT a relocatable package

%define ver	0.9.10
%define rel	1

Name:      xmlrpc-c
Summary:   A library implementing XML-based remote procedure calls
Version:   %ver
Release:   %rel
Copyright: New-style BSD License
Group:     System Environment/Libraries
Source:    http://download.sourceforge.net/xmlrpc-c/xmlrpc-c-%{ver}.tar.gz
URL:       http://xmlrpc-c.sourceforge.net/
BuildRoot: /var/tmp/%{name}-root
Requires:  w3c-libwww >= 5.2.8

%description
XML-RPC is a lightweight RPC protocol based on XML and HTTP. This package
is used by XML-RPC clients and servers written in C and C++. 


%package devel
Summary:   Libraries and header files for developing XML-RPC applications
Group:     Development/Libraries
Requires:  xmlrpc-c

%description devel
Static libraries and header files for writing XML-RPC applications in C and
C++.


%package apps
Summary:   Sample XML-RPC applications
Group:     Applications/Internet
Requires:  xmlrpc-c

%description apps

Some handy XML-RPC demo applications based on the Meerkat Open Wire Service
(found at http://www.oreillynet.com/meerkat/). You can use 'query-meerkat' to
perform a regex search on recent news items, or 'meerkat-app-list' to get
a list of recent Linux software releases.


%prep
%setup -q

%build
%configure --mandir=%{_prefix}/share/man --infodir=%{_prefix}/share/info
make

%install
make DESTDIR=$RPM_BUILD_ROOT install

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root)
%{_prefix}/lib/lib*.so.*
%doc NEWS BUGS COPYING CREDITS README SECURITY 
%doc doc/*.txt examples/*.c examples/*.cc
%doc conf
%{_prefix}/share/man/man7/xmlrpc-c.7*

%files devel
%defattr(-,root,root)
%{_prefix}/bin/xmlrpc-c-config
%{_prefix}/bin/xml-rpc-api2txt
%{_prefix}/bin/xml-rpc-api2cpp
%{_prefix}/lib/lib*.a
%{_prefix}/lib/lib*.la
%{_prefix}/lib/lib*.so
%{_prefix}/include/*.h
%{_prefix}/share/man/man1/xmlrpc-c-config.1*
%{_prefix}/share/man/man1/xml-rpc-api2txt.1*
%{_prefix}/share/man/man1/xml-rpc-api2cpp.1*

%files apps
%defattr(-,root,root)
%{_prefix}/bin/query-meerkat
%{_prefix}/bin/meerkat-app-list
%{_prefix}/share/man/man1/query-meerkat.1*
%{_prefix}/share/man/man1/meerkat-app-list.1*

%changelog
* Wed Jun 27 2001 Eric Kidd <eric.kidd@pobox.com>
- Added man pages.
- Set man directory to /usr/share/man.  This seems to be standard now.

* Sun Apr 03 2001 Eric Kidd <eric.kidd@pobox.com>
- Added xml-rpc-api2cpp.

* Sun Jan 14 2001 Eric Kidd <eric.kidd@pobox.com>
- Removed dependency on w3c-libwww-xmlrpc.

* Mon Jan 08 2001 Eric Kidd <eric.kidd@pobox.com>
- Added C++ support, meerkat-app-list.

* Mon Jan 08 2001 Eric Kidd <eric.kidd@pobox.com>
- Added apps package, query-meerkat.

* Sun Jan 07 2001 Eric Kidd <eric.kidd@pobox.com>
- New package.
