/* ,file-id archive://[lord]/456/rx/unfa.h/1998-05-18
 */
#ifndef RXUNFAH
#define RXUNFAH

/*	Copyright (C) 1997 Tom Lord
 * 
 * This program is provided to you under the terms of the Liberty Software
 * License.  You are NOT permitted to redistribute, modify, or use it
 * except in very specific ways described by that license.
 *
 * This software comes with NO WARRANTY.
 * 
 * You should have received a copy of the Liberty Software License
 * along with this software; see the file =LICENSE.  If not, write to
 * the Tom Lord, 1810 Francisco St. #2, Berkeley CA, 94703, USA.  
 */



/* Unique NFAs
 *
 * Equal regexps (in the sense of rx_copy_rexp) must always yield 
 * equivalent NFAs.  If they yield eq NFAs (in the sense of "==")
 * then the matcher can cache the NFA => DFA translation more
 * effectively.
 *
 * The procedures here maintain a cached mapping
 * from regexps to NFAs, so that equal regexps will
 * tend to yield eq NFAs.
 *
 */

struct rx_unfa
{
  int refs;
  int cset_size;
  struct rx_exp_node * exp;
  struct rx_nfa * nfa;
};



/* automatically generated __STDC__ prototypes */
extern struct rx_unfa * rx_unfa (struct rx_exp_node * exp, int cset_size);
extern void rx_save_unfa (struct rx_unfa * unfa);
extern void rx_free_unfa (struct rx_unfa * unfa);
#endif  /* RXUNFAH */
