#include "xev.h"
#include "enemy.h"

PRIVATE char *fn[] = {
      "gido1.img",
      "gido2.img",
};

PRIVATE Pixmap pixmap[2];
PRIVATE Pixmap pixmap_mask[2];
PRIVATE GC gc[2];

void GidoSetChar()
{
      int c_no;
      char img[CSIZE*CSIZE] , mask[32];
      XGCValues gcv;
      
      gcv.graphics_exposures = False;
      for(c_no = 0 ; c_no < 2 ; c_no++) {
            int x,y;

            sprintf(tpath , "%s/%s",IMAGE_DIR,fn[c_no]);
            LoadChar(tpath,img , sizeof(img));
            pixmap[c_no] = XCreatePixmap(d,w,CSIZE/2,CSIZE/2,depth);
            bzero(mask , sizeof(mask));
	    gc[c_no] = XCreateGC(d,w,GCGraphicsExposures,&gcv);

	    for(y = 0 ; y < CSIZE/2 ; y++)
              for(x = 0 ; x < CSIZE/2 ; x++) {
                    if(img[y*CSIZE+x] != 100) {
                          mask[y*2+x/8] |= (1<< (x%8));
                          XSetForeground(d,gc[c_no],
                                         pixel[img[y*CSIZE+x]]);
                          XDrawPoint(d,pixmap[c_no],gc[c_no],x,y);
                    }
              }
            pixmap_mask[c_no] 
              = XCreateBitmapFromData(d,w,mask,CSIZE/2,CSIZE/2);
            XSetClipMask(d,gc[c_no],pixmap_mask[c_no]);
      }
}

void GidoFree()
{
      int i;

      for(i = 0 ; i < 2 ; i++) {
	    XFreePixmap(d,pixmap[i]);
	    XFreePixmap(d,pixmap_mask[i]);
	    XFreeGC(d,gc[i]);
      }
}

void GidoInit(enemy_no)
     int enemy_no;
{
      short sgnx,sgny,absxy,v;
      int i;

      enemy[enemy_no].enemy_no = GIDO;
      enemy[enemy_no].tmp1 = 0;
      enemy[enemy_no].tmp2 = 0;
      
      enemy[enemy_no].x.sht[UNION] = rand() % XSIZE;
      enemy[enemy_no].y.sht[UNION] = -32;

      sgnx = jx.sht[UNION] - enemy[enemy_no].x.sht[UNION];
      sgny = jy.sht[UNION] - enemy[enemy_no].y.sht[UNION];
      absxy = 1+ABS(sgnx) + ABS(sgny);

      v = (rand() % 6+ 10)*STPF;
      enemy[enemy_no].vx = v*sgnx*87000/absxy;
      enemy[enemy_no].vy = v*sgny*87000/absxy;
      
}

int Gido(enemy_no)
     int enemy_no;
{
      int i;
      int yararetaTL = 0;
      int dx,dy;
      int sx,sy;
      
      enemy[enemy_no].x.dummy += enemy[enemy_no].vx;
      enemy[enemy_no].y.dummy += enemy[enemy_no].vy;
      enemy[enemy_no].tmp1 = 1-enemy[enemy_no].tmp1;
      sx = enemy[enemy_no].x.sht[UNION];
      sy = enemy[enemy_no].y.sht[UNION];
      dx = jx.sht[UNION] - sx; dy = jy.sht[UNION] - sy; 
      
      if(dx > -10 && dx < 10 && dy > -10 && dy < 10)
        yararetaTL = 1;
      
      for(i = 0 ; i < SHOT_NUM ; i++)
        {
              if(!shot[i].flag)
                continue;
	      
	      if((shot[i].x.sht[UNION] - sx) > -40 && 
		 (shot[i].x.sht[UNION] - sx) < 40
		 && (shot[i].y.sht[UNION] - sy) > -44 && 
		 (shot[i].y.sht[UNION] - sy) < 5)
		{
		      score += 10;
		      shot[i].flag = 0;
                      BombInit(enemy_no);
		      return 0;
                }
        }
      
      if(sx < 0 ||sx > XSIZE
         || sy > YSIZE)
	{
              enemy[enemy_no].enemy_no = 0;
        }
      else
        {
	      SetSprite(enemy[enemy_no].x.sht[UNION],
			enemy[enemy_no].y.sht[UNION],
			pixmap[enemy[enemy_no].tmp1],
			gc[enemy[enemy_no].tmp1],
			CSIZE/2,
			CSIZE/2);
        }
      
      return yararetaTL;
}



