/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import java.util.Vector;
import org.xml.sax.SAXException;

public class Concat
extends Function {
    public String getName() {
        return "concat";
    }

    public int getDataType() {
        return 3;
    }

    public Value eval(Vector vector, Context context) throws SAXException {
        int n = vector.size();
        if (n < 2) {
            throw new SAXException("The concat() function must have two or more arguments");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            Value value = (Value)vector.elementAt(n2);
            stringBuffer.append(value.asString());
            ++n2;
        }
        return new StringValue(stringBuffer.toString());
    }

    public Expression simplify() throws SAXException {
        return this.simplifyPureFunction();
    }
}

