/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "JT44Lookups.h"

#include <wx/wx.h>

static const struct {
	wxChar c;
	int    n;
} jt44Table[] = {
	{wxT('0'), 121}, {wxT('1'), 122}, {wxT('2'), 123}, {wxT('3'), 124}, {wxT('4'), 125}, {wxT('5'), 126},
	{wxT('6'), 127}, {wxT('7'), 128}, {wxT('8'), 129}, {wxT('9'), 130}, {wxT('.'), 131}, {wxT(','), 132},
	{wxT(' '), 133}, {wxT('/'), 134}, {wxT('#'), 135}, {wxT('?'), 136}, {wxT('$'), 137}, {wxT('A'), 138},
	{wxT('a'), 138}, {wxT('B'), 139}, {wxT('b'), 139}, {wxT('C'), 140}, {wxT('c'), 140}, {wxT('D'), 141},
	{wxT('d'), 141}, {wxT('E'), 142}, {wxT('e'), 142}, {wxT('F'), 143}, {wxT('f'), 143}, {wxT('G'), 144},
	{wxT('g'), 144}, {wxT('H'), 145}, {wxT('h'), 145}, {wxT('I'), 146}, {wxT('i'), 146}, {wxT('J'), 147},
	{wxT('j'), 147}, {wxT('K'), 148}, {wxT('k'), 148}, {wxT('L'), 149}, {wxT('l'), 149}, {wxT('M'), 150},
	{wxT('m'), 150}, {wxT('N'), 151}, {wxT('n'), 151}, {wxT('O'), 152}, {wxT('o'), 152}, {wxT('P'), 153},
	{wxT('p'), 153}, {wxT('Q'), 154}, {wxT('q'), 154}, {wxT('R'), 155}, {wxT('r'), 155}, {wxT('S'), 156},
	{wxT('s'), 156}, {wxT('T'), 157}, {wxT('t'), 157}, {wxT('U'), 158}, {wxT('u'), 158}, {wxT('V'), 159},
	{wxT('v'), 159}, {wxT('W'), 160}, {wxT('w'), 160}, {wxT('X'), 161}, {wxT('x'), 161}, {wxT('Y'), 162},
	{wxT('y'), 162}, {wxT('Z'), 163}, {wxT('z'), 163}};

static const int positionTable[] =
	{-1, -1, -1,  0, -1,  1,  2,  3,  4, -1,
	 -1, -1,  5,  6, -1, -1,  7,  8,  9, 10,

	 -1, 11, 12, -1, 13, 14, 15, -1, 16, -1,
	 17, -1, -1, -1, 18, -1, 19, -1, -1, -1,

	 -1, 20, 21, -1,  0,  1, -1,  2, -1, -1,
	 -1,  3,  4, -1, -1, -1,  5,  6,  7,  8,

	  9, 10, -1, -1, -1, 11, -1, -1, -1, 12,
	 -1, 13, 14, -1, -1, -1, -1, 15, -1, 16,

	 -1, 17, 18, -1, 19, -1, 20, 21,  0,  1,
	  2,  3, -1,  4, -1,  5, -1,  6, -1,  7,

	 -1, -1, -1, -1, -1,  8, -1,  9, -1, -1,
	 10, -1, 11, 12, 13, 14, 15, -1, -1, 16,

	 -1, -1, -1, 17, -1, -1, 18, -1, -1, 19,
	 -1, 20, -1, -1, 21 };


CJT44Lookups::CJT44Lookups()
{
}

CJT44Lookups::~CJT44Lookups()
{
}

bool CJT44Lookups::lookupSync(int n) const
{
	return lookupPosition(n) == -1;
}

int CJT44Lookups::lookupChar(wxChar c) const
{
	for (int i = 0; i < 69; i++) {
		if (jt44Table[i].c == c)
			return jt44Table[i].n;
	}

	return -1;
}

wxChar CJT44Lookups::lookupTone(int n) const
{
	for (int i = 0; i < 69; i++) {
		if (jt44Table[i].n == n)
			return jt44Table[i].c;
	}

	return wxChar(0);
}

int CJT44Lookups::lookupPosition(int n) const
{
	wxASSERT(n >= 0 && n <= 134);

	return positionTable[n];
}
