/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "JT6MCardReceive.h"
#include "JT6MDefs.h"

#include "JT6MApp.h"

#include "common/SoundFile.h"

#include <wx/datetime.h>
#include <wx/debug.h>
#include <wx/filename.h>
#include <wx/log.h>

CJT6MCardReceive::CJT6MCardReceive(const wxString& name, ISoundDev* soundDev, EWho who) :
CJT6MReceive(name, who),
m_soundDev(soundDev)
{
	wxASSERT(m_soundDev != NULL);
}

CJT6MCardReceive::~CJT6MCardReceive()
{
}

bool CJT6MCardReceive::getEndTime()
{
	wxDateTime now = wxDateTime::UNow();

	if (now.GetSecond() != 29 && now.GetSecond() != 59)
		return false;

	return (now.GetMillisecond() > 250);
}

void CJT6MCardReceive::openSoundDevice()
{
	wxASSERT(m_soundDev != NULL);

	m_soundDev->openRead();
}

void CJT6MCardReceive::closeSoundDevice()
{
	wxASSERT(m_soundDev != NULL);

	m_soundDev->close();
}

void CJT6MCardReceive::recordAudio(const wxString& id, double* audioData, int length) const
{
	wxASSERT(audioData != NULL);
	wxASSERT(length > 0);

	if (isRecording()) {
		wxString pathAudio, pathText;
		::wxGetApp().getPaths(pathAudio, pathText);

		wxFileName fileName(pathAudio, id, wxT("wav"));

		CSoundFile* file = new CSoundFile(fileName.GetFullPath(), JT6M_SAMPLE_RATE, 8);
		file->openWrite();

		file->write(audioData, length);

		file->close();

		delete file;
	}
}

wxString CJT6MCardReceive::createId()
{
	wxDateTime now = wxDateTime::Now();

	return now.Format(wxT("%Y%m%d_%H%M%S"), wxDateTime::UTC);
}

void CJT6MCardReceive::error(const wxString& text)
{
	::wxLogError(wxT("%s: %s"), getName().c_str(), text.c_str());

	::wxGetApp().error(text);
}
