/*
 *  WSoundPrefs - WMSound Server Preferences Program
 *
 * Copyright (c) 1998, 1999 Pascal Hofstee
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "WSoundPrefs.h"
#include "SoundPaths.h"

extern proplist_t WMSoundDomain;

static void addPathToList(WMList *list, int index, char *path);


void
paintItem(WMList *lPtr, int index, Drawable d, char *text, int state, WMRect *rect)
{
	int		width, height, x, y;
	Panel		*panel = (Panel*)WMGetHangedData(lPtr);
	WMScreen	*scr = WMWidgetScreen(lPtr);
	Display		*dpy = WMScreenDisplay(scr);
	
	width = rect->size.width;
	height = rect->size.height;
	x = rect->pos.x;
	y = rect->pos.y;
	
	if (state & WLDSSelected)
		XFillRectangle(dpy, d, WMColorGC(panel->white), x, y, width, height);
	else
		XClearArea(dpy, d, x, y, width, height, False);

	if (state & 1)
		WMDrawString(scr, d, WMColorGC(panel->red), panel->font, x+4, y, text, strlen(text));
	else
		WMDrawString(scr, d, WMColorGC(panel->black), panel->font, x+4, y,text, strlen(text));
}

void
setSoundPathData(Panel *panel)
{
	proplist_t	array, val;
	int		i;
	
	array = GetObjectForKey("SoundPath");
	if (!array || !PLIsArray(array)) {
		if (array)
			wwarning(_("bad value in option SoundPath. Using default path list"));
		addPathToList(panel->sndL, -1, "~/GNUstep/Library/WindowMaker/Sounds");
		addPathToList(panel->sndL, -1, "/usr/local/share/WindowMaker/Sounds");
	} else {
		for (i=0; i<PLGetNumberOfElements(array); i++) {
			val = PLGetArrayElement(array, i);
			addPathToList(panel->sndL, -1, PLGetString(val));
		}
	}
}

void
setSoundSetPathData(Panel *panel)
{
	proplist_t	array, val;
	int		i;
	
	array = GetObjectForKey("SoundSetPath");
	if (!array || !PLIsArray(array)) {
		if (array)
			wwarning(_("bad value in option SoundSetPath. Using default path list"));
		addPathToList(panel->sndsetL, -1, "~/GNUstep/Library/WindowMaker/SoundSets");
		addPathToList(panel->sndsetL, -1, "/usr/local/share/WindowMaker/SoundSets");
	} else {
		for (i=0; i<PLGetNumberOfElements(array); i++) {
			val = PLGetArrayElement(array, i);
			addPathToList(panel->sndsetL, -1, PLGetString(val));
		}
	}
}

static void
addPathToList(WMList *list, int index, char *path)
{
	char		*fpath = wexpandpath(path);
	WMListItem	*item;
	
	item = WMInsertListItem(list, index, path);
	
	if (access(fpath, X_OK)!=0)
		item->uflags = 1;
	
	free(fpath);
}

void
browseForPath(WMWidget *w, void *data)
{
	Panel		*panel = (Panel*)data;
	WMFilePanel	*filePanel;

	filePanel = WMGetOpenPanel(WMWidgetScreen(w));
	WMSetFilePanelCanChooseFiles(filePanel, False);
	
	if (WMRunModalFilePanelForDirectory(filePanel, panel->win, "/",
				_("Select directory"), NULL) == True) {
		char *str = WMGetFilePanelFileName(filePanel);
		
		if (str) {
			int len = strlen(str);
			
			/* Remove the trailing '/' except if the path is exactly / */
			if (len > 1 && str[len-1] == '/') {
				str[len-1] = '\0';
				len--;
			}
			if (len > 0) {
				WMList	*lPtr;
				int	i;
				
				if (w == panel->sndaB)
					lPtr = panel->sndL;
				else if (w == panel->sndsetaB)
					lPtr = panel->sndsetL;
				
				i = WMGetListSelectedItemRow(lPtr);
				if (i >= 0) i++;
				addPathToList(lPtr, i, str);
				WMSetListBottomPosition(lPtr, WMGetListNumberOfRows(lPtr));

				free(str);
			}
		}
	}
}

void
removePath(WMWidget *w, void *data)
{
	Panel	*panel = (Panel*)data;
	int	i;
	
	/* sound paths */
	if (w == panel->sndrB) {
		i = WMGetListSelectedItemRow(panel->sndL);
		
		if (i>=0)
			WMRemoveListItem(panel->sndL, i);
	}
	
	/* soundset paths */
	if (w == panel->sndsetrB) {
		i = WMGetListSelectedItemRow(panel->sndsetL);
		
		if (i>=0)
			WMRemoveListItem(panel->sndsetL, i);
	}
}

