/* searchentryop.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2004 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: searchentryop.h,v 1.8 2004/10/27 21:08:58 ralf Exp $ */

#ifndef SEARCHENTRYOP_H
#define SEARCHENTRYOP_H

#include "wdefines.h"
#include "functionproto.h"

class SearchEntryOp:public FunctionProto
{
public:
  SearchEntryOp();
  virtual ~SearchEntryOp();
  SearchEntryOp( const SearchEntryOp &other );
  SearchEntryOp &operator=( const SearchEntryOp &other );

  virtual SearchEntryOp *duplicate() const;
  virtual bool isName(const char *);
  virtual const char *getName();
#if ! ( defined ( __GNUC__ ) && ( __GNUC__ < 3 ) )
  using FunctionProto::run;
#endif
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
  virtual bool save(Datei*);
  void setIgnoreCase( bool );
  virtual int configure();
protected:
  static const char *name;
  // Infos to save
  bool ignore_case;

  // temp variables
  Lister *startlister;
  
  int normalmodesearchentry();
};

#endif
