#!/usr/bin/perl

$test="true";


use IMAP::Sieve;

sub opensieve {
	my ($uid,$pass,$proxy,$server,$port)=@_;
	$sieve=IMAP::Sieve->new('Proxy'=>$proxy,'Server'=>$server,'Login'=>$uid,'Password'=>$pass,'Port'=>$port);
	return;
}
	
sub closesieve {
	 if ($sieve) {$sieve->close};
}

sub listscripts {
   	@scripts=$sieve->listscripts;
   	return (join("\n",@scripts)."\n") ;
}   	
   	
sub getscript {
	my ($script) = @_;
	my ($scriptfile);

	$scriptfile=$sieve->getscript($script);
	return $scriptfile;
}

sub putscript {
	my ($scriptname,$script) = @_;
	$res=$sieve->putscript($scriptname,$script);
	if ($res) {print $sieve->{'Error'}}
	return;
}
	
sub setactive {
	my ($script)=@_;
	$res=$sieve->setactive($script);
	if ($res) { print $sieve->{'Error'};}
	return;
}
	
sub noop {
	$test=$sieve->noop;
	return;
}

sub deletescript {
	my ($script)=@_;
	$res=$sieve->deletescript($script);
	if ($res) {print $sieve->{'Error'};}
	return;
}
	
sub readscript {
	open (IN,"./testscript");
	$script="";
	while (<IN>) {
		$script.=$_;
	}
}
if ($test) {
$script="# this is a test script\n#test again\n";
print "Sieve server hostname: <localhost> ";
chomp($server = <>);
$server = 'localhost' if !$server;
print "Sieve daemon port: <2000>";
chomp($port=<>);
$port='2000' if !$port;
print "Please enter the user and password at the prompts\n";
print "Enter login name: ";
chomp($login = <>);
print "Enter password: ";
chomp($password = <>);
print "Enter user ID to proxy as(Press Enter if same as Login): ";
chomp($proxy = <>);

print "\n##opening connection\n";
&opensieve($login,$password,$proxy,$server,$port);
print $sieve->{'Error'}."\n";
print "Capability=$sieve->{'Capability'}\n";

print "\m##saving script\n";
&putscript('test1',$script);
print $sieve->{'Error'}."\n";

print "\n##listing scripts\n";
print &listscripts;

print "\n##getting script\n";
print &getscript('test1');
print $sieve->{'Error'}."\n";

print "\n##setting active script\n";
&setactive('test1');
print $sieve->{'Error'}."\n";

print "\n##listing scripts again\n";
print &listscripts;

print "\n##deleting a script\n";
&deletescript('test1');
print $sieve->{'Error'}."\n";

print "\n##listing scripts\n";
print &listscripts;
print $sieve->{'Error'}."\n";

print "\n##closing connection\n";
&closesieve;
print $sieve->{'Error'}."\n";

}
1;
