#!/usr/local/bin/perl
# rename.cgi
# Actually rename a server

require './virtual-server-lib.pl';
&ReadParse();
$d = &get_domain($in{'dom'});
$access{'norename'} && &error($text{'rename_ecannot'});
$access{'edit'} && &can_edit_domain($d) || &error($text{'edit_ecannot'});

# Validate inputs
$in{'new'} =~ /^[A-Za-z0-9\.\-]+$/ || &error($text{'rename_enew'});
$in{'new'} = lc($in{'new'});
$in{'new'} ne $d->{'dom'} || &error($text{'rename_esame'});
if (!$d->{'parent'} && &master_admin()) {
	if ($in{'user_mode'} == 1) {
		# Make up a new username
		($user, $try1, $try2) = &unixuser_name($in{'new'});
		$user || &error(&text('setup_eauto', $try1, $try2));
		}
	elsif ($in{'user_mode'} == 2) {
		# Use the entered username
		$in{'user'} || &error($text{'rename_euser'});
		$user = $in{'user'};
		}
	}

# Make sure new domain is valid
local $parentdom = $d->{'parent'} ? &get_domain($d->{'parent'})
				  : undef;
if ($parentdom) {
	local $derr = &valid_domain_name($parentdom, $in{'new'});
	&error($derr) if ($derr);
	}

# Make sure no domain with the same name already exists
@doms = &list_domains();
($clash) = grep { $_->{'dom'} eq $in{'new'} } @doms;
$clash && &error($text{'rename_eclash'});

# Update the domain object, where appropriate
%oldd = %$d;
$d->{'dom'} = $in{'new'};
if ($user) {
	$d->{'user'} = $user;
	}
if ($in{'home_mode'}) {
	$d->{'home'} = &server_home_directory($d, $parentdom);
	local $k;
	foreach $k (keys %$d) {
		if ($k ne "home") {
			$d->{$k} =~ s/$oldd{'home'}/$d->{'home'}/g;
			}
		}
	}

# Find any sub-domain objects and update them
if (!$d->{'parent'}) {
	@subs = &get_domain_by("parent", $d->{'id'});
	foreach $sd (@subs) {
		local %oldsd = %$sd;
		push(@oldsubs, \%oldsd);
		if ($user) {
			$sd->{'user'} = $user;
			}
		if ($in{'home_mode'}) {
			$sd->{'home'} = &server_home_directory($sd, $d);
			local $k;
			foreach $k (keys %$sd) {
				$sd->{$k} =~ s/$oldsd{'home'}/$sd->{'home'}/g;
				}
			}
		}
	}

# Find any domains aliases to this one, excluding child domains
@aliases = &get_domain_by("alias", $d->{'id'});
@aliases = grep { $_->{'parent'} != $d->{'id'} } @aliases;
foreach $ad (@aliases) {
	local %oldad = %$ad;
	push(@oldaliases, \%oldad);
	}

# Check for domain name clash
my $f;
foreach $f (@features) {
	if ($in{$f}) {
		local $cfunc = "check_${f}_clash";
		if (&$cfunc($d, 'dom')) {
			&error(&text('setup_e'.$f, $in{'dom'}, $dom{'db'}, $user, $group));
			}
		if ($user) {
			if (&$cfunc($d, 'user')) {
				&error(&text('setup_e'.$f, $in{'dom'},
					     $dom{'db'}, $user, $group));
				}
			}
		}
	}

# Run the before command
&set_domain_envs(\%oldd, "MODIFY_DOMAIN");
$merr = &making_changes();
&error(&text('rename_emaking', "<tt>$merr</tt>")) if (defined($merr));

&ui_print_unbuffered_header(&domain_in(\%oldd), $text{'rename_title'}, "");

print "<b>",&text('rename_doing', "<tt>$in{'new'}</tt>");
print &text('rename_doinguser', "<tt>$user</tt>"),"\n" if ($user);
print "...</b><p>\n";

# Build the list of domains being changed
@doms = ( $d );
@olddoms = ( \%oldd );
push(@doms, @subs, @aliases);
push(@olddoms, @oldsubs, @oldaliases);

# Setup print function to include domain name
sub first_html_withdom
{
print &text('rename_dd', $doing_dom->{'dom'})," : ",@_,"<br>\n";
}
if (@doms > 1) {
	$first_print = \&first_html_withdom;
	}

# Update all features in all domains
my $f;
foreach $f (@features) {
	local $mfunc = "modify_$f";
	my $i;
	for($i=0; $i<@doms; $i++) {
		if ($doms[$i]->{$f} && $config{$f} || $f eq "unix") {
			$doing_dom = $doms[$i];
			if ($doms[$i]->{'alias'}) {
				# Is an alias domain, so pass in old and new
				# target domain objects
				local $aliasdom = &get_domain($doms[$i]->{'alias'});
				local $idx = &indexof($aliasdom, @doms);
				if ($idx >= 0) {
					&$mfunc($doms[$i], $olddoms[$i],
						$doms[$idx], $olddoms[$idx]);
					}
				else {
					&$mfunc($doms[$i], $olddoms[$i],
						$aliasdom, $aliasdom);
					}
				}
			else {
				# Not an alias domain
				&$mfunc($doms[$i], $olddoms[$i]);
				}
			}
		}
	}
foreach $f (@feature_plugins) {
	for($i=0; $i<@doms; $i++) {
		if ($doms[$i]->{$f}) {
			$doing_dom = $doms[$i];
			&plugin_call($f, "feature_modify", $doms[$i], $olddoms[$i]);
			}
		}
	}

if ($d->{'parent'}) {
	# Update the parent Webmin user to refresh ACLs for new domain
	$parentdom = &get_domain($d->{'parent'});
	&modify_webmin($parentdom, $parentdom);
	}
&run_post_actions();

# Save all new domain details
print $text{'save_domain'},"<br>\n";
for($i=0; $i<@doms; $i++) {
	&save_domain($doms[$i]);
	}
print $text{'setup_done'},"<p>\n";

# Run the after command
&set_domain_envs($d, "MODIFY_DOMAIN");
&made_changes();
&webmin_log("rename", "domain", $oldd{'dom'}, $d);

&ui_print_footer("edit_domain.cgi?dom=$in{'dom'}", $text{'edit_return'},
	"", $text{'index_return'});
