#!/usr/local/bin/perl
# Create, update or delete the backup cron job

require './virtual-server-lib.pl';
&master_admin() || &error($text{'backup_ecannot'});
&ReadParse();

# Validate inputs
&error_setup($text{'backup_err2'});
if ($in{'all'}) {
	@doms = &list_domains();
	}
elsif ($in{'all'} == 2) {
	%exc = map { $_, 1 } split(/\0/, $in{'doms'});
	@doms = grep { !$exc{$_->{'id'}} } &list_domains();
	}
else {
	foreach $d (split(/\0/, $in{'doms'})) {
		push(@doms, &get_domain($d));
		}
	}
@doms || &error($text{'backup_edoms'});
@do_features = split(/\0/, $in{'feature'});
@do_features || &error($text{'backup_efeatures'});
$dest = &parse_backup_destination("dest", \%in);

# Parse option inputs
foreach $f (@do_features) {
	local $ofunc = "parse_backup_$f";
	if (defined(&$ofunc)) {
		$options{$f} = &$ofunc(\%in);
		}
	}

# Check if the cron job exists
&foreign_require("cron", "cron-lib.pl");
local @jobs = &cron::list_cron_jobs();
local ($job) = grep { $_->{'user'} eq 'root' &&
		      $_->{'command'} eq $backup_cron_cmd } @jobs;

# Create, update or delete it
if ($job && $in{'enabled'}) {
	# Update job
	&lock_file(&cron::cron_file($job));
	&cron::parse_times_input($job, \%in);
	&cron::change_cron_job($job);
	&unlock_file(&cron::cron_file($job));
	$what = "modify";
	}
elsif (!$job && $in{'enabled'}) {
	# Create job
	$job = { 'user' => 'root',
		 'command' => $backup_cron_cmd,
		 'active' => 1 };
	&lock_file(&cron::cron_file($job));
	&cron::parse_times_input($job, \%in);
	&cron::create_cron_job($job);
	&lock_file($backup_cron_cmd);
	&cron::create_wrapper($backup_cron_cmd, $module_name, "backup.pl");
	&unlock_file($backup_cron_cmd);
	&unlock_file(&cron::cron_file($job));
	$what = "create";
	}
elsif ($job && !$in{'enabled'}) {
	# Delete job
	&lock_file(&cron::cron_file($job));
	&cron::delete_cron_job($job);
	&unlock_file(&cron::cron_file($job));
	$what = "delete";
	}
else {
	$what = "none";
	}

# Update module config with domains and features
$config{'backup_all'} = $in{'all'};
$config{'backup_doms'} = join(" ", split(/\0/, $in{'doms'}));
%features = map { $_, 1 } @do_features;
foreach $f (@backup_features) {
	$config{'backup_feature_'.$f} = $features{$f} ? 1 : 0;
	}
$config{'backup_dest'} = $dest;
$config{'backup_fmt'} = $in{'fmt'};
$config{'backup_email'} = $in{'email'};
$config{'backup_errors'} = $in{'errors'};
$config{'backup_strftime'} = $in{'strftime'};
$config{'last_check'} = time()+1;	# no need for check.cgi to be run
foreach $f (keys %options) {
	$config{'backup_opts_'.$f} = join(",", map { $_."=".$options{$f}->{$_} } keys %{$options{$f}});
	}
&lock_file($module_config_file);
&save_module_config();
&unlock_file($module_config_file);
&webmin_log("sched", $what);

# Return to main menu
&redirect("");

