// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

//---------------------------------------------------------------------------
// 
// $Id: SequentialSimulationStream.cpp
// 
//---------------------------------------------------------------------------

#include "SequentialSimulationStream.h"
using std::cerr;
using std::endl;

SequentialSimulationStream::SequentialSimulationStream(const string& fileName,
                                                       ios::openmode mode)
  : closeflag( true ){
  // Open the file the user has specified
  fstream::open(fileName.c_str(), mode);
  
  // check if the open operation was successful...
   if (!good()) {
     cerr << "SequentialSimulationStream:: Error Opening File - "
	  << fileName << endl;
     exit(-41);
   }

   //   setBuffer(mode);
}

SequentialSimulationStream::SequentialSimulationStream( streambuf *buf,
							ios::openmode mode )
  : closeflag(false) {
  ios::rdbuf( buf );
}


SequentialSimulationStream::~SequentialSimulationStream(){
  flush();
  if( closeflag == true ){
    close();
  }
}
