// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

//---------------------------------------------------------------------------
// 
// $Id: InFileQueue.cpp
// 
//---------------------------------------------------------------------------

#include "InFileQueue.h"
#include <cstdio>
using std::ios;
using std::cout;
using std::cerr;
using std::endl;

InFileQueue::InFileQueue(const string& fileName )
  : inFileName( fileName ){
  open( fileName );
}

InFileQueue::~InFileQueue() {
//   garbageCollect(VTimeFactory::getPositiveInfinity());
  inFile.close();
}

void 
InFileQueue::open(const string &fileName) {

  inFileName = fileName;
  
  inFile.open(inFileName.c_str(), ios::in);
  if (!inFile.good()) {
    perror( ("InFileQueue: Error Opening File: " + inFileName).c_str() );
  }
}

void
InFileQueue::close() {
//   garbageCollect(VTimeFactory::getPositiveInfinity());
  inFile.close();
}

void 
InFileQueue::garbageCollect(const VTime &garbageCollectTime){

   multiset< InFileData >::iterator iter_begin = begin();
   multiset< InFileData >::iterator iter_end = end();
   
   while(iter_begin != iter_end){
      if ((*iter_begin).getTime() <= garbageCollectTime){
         // this is a little trick using iterators.
         // the old value of iter_begin is saved and passed to erase
         // AFTER the iterator has been incremented.
         erase(iter_begin++);
      }
      else {
         break;
      }
   }
}

void
InFileQueue::rollbackTo(const VTime &rollbackToTime){

   InFileData findElement(rollbackToTime);
   multiset< InFileData >::iterator iter_find = lower_bound(findElement);
   // delete every thing after (and including) the found element
   erase(iter_find, end());
}

void 
InFileQueue::storePos(const VTime &time) {

   InFileData inPos(time, inFile.tellg());
   insert(inPos);
}


