// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

//---------------------------------------------------------------------------
// 
// $Id: GVTManagerImplementationBase.cpp
// 
//---------------------------------------------------------------------------

#include "GVTManagerImplementationBase.h"
#include "TimeWarpSimulationManager.h"

using std::cerr;
using std::endl;

GVTManagerImplementationBase::GVTManagerImplementationBase( TimeWarpSimulationManager
							    *simMgr,
							    unsigned int
							    period) :
  gVTPeriodCounter(0),
  gVTPeriod( period ),
  mySimulationManager( simMgr ),
  gVT( simMgr->getZero().clone() ){}

GVTManagerImplementationBase::~GVTManagerImplementationBase(){
  delete gVT;
}

bool
GVTManagerImplementationBase::checkGVTPeriod(){
  if(++gVTPeriodCounter == gVTPeriod){
    gVTPeriodCounter = 0;
    return true;
  }
  else {
    return false;
  }
}

void
GVTManagerImplementationBase::updateEventRecord(const char *infoStream,
                                                unsigned int srcSimMgr){
  cerr << "GVTManagerImplementationBase::updateEventRecord() called: "
       << "(" << srcSimMgr << "), " << infoStream << endl;
  abort();
}

const VTime &
GVTManagerImplementationBase::getGVT(){
  ASSERT( gVT != 0 );
  return *gVT;
}

const string
GVTManagerImplementationBase::getGVTInfo(unsigned int srcSimMgr,
                                         unsigned int destSimMgr,
					 const VTime &sendTime){
  cerr << "GVTManagerImplementationBase::getGVTInfo() called: ("
       << srcSimMgr << "," << destSimMgr << ")" << endl;
  abort();
  return NULL;
}


void
GVTManagerImplementationBase::calculateGVT(){
  cerr << "GVTManagerImplementationBase::calculateGVT() called !!"
       << endl;
  abort();
}

void
GVTManagerImplementationBase::sendGVTUpdate(){
  cerr << "GVTManagerImplementationBase::sendGVTUpdate() called !!"
       << endl;
  abort();
}

void
GVTManagerImplementationBase::configure( SimulationConfiguration &configuration ){
  registerWithCommunicationManager();
}
