#ifndef FACTORY_H
#define FACTORY_H

// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include <string>
#include "Types.h"

using std::string;

/** The Factory abstract base class.  

    All classes related to the object factory subsystem must be
    derived from this base class.  The base class provides a common
    point for may disjoint classes such as the main-factory,
    sub-factory, object stubs etc. The base class is useful to provide
    an uniform interface for all these classes. This class cannot be
    directly instantiated.

**/
class Factory {
public:
   /**@name Public Class Methods of Factory */
   //@{
   
   /// Destructor.
   virtual ~Factory() {};
   
   /** Return the name of this factory object.

       This is a pure virtual function that has to be overridden.

       @return The name of this factory object.
   */
   virtual const string& getName() const = 0;

   /** Return the kind of this factory object.

       This is a pure virtual function that has to be overridden.

       @return The kind of this factory object.
   */
   virtual const Kind  getKind() const = 0;

   //@} // End of Factory Public Class Methods.

protected:
   
   /**@name Protected Class Methods of Factory */
   //@{

   /// Constructor
   Factory() {};

   //@} // End of Protected Class Methods of Factory.
};

#endif
