#ifndef CONFIGURABLE_H
#define CONFIGURABLE_H

// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include <clutils/StringHashMap.h>
#include <vector>

using std::vector;

class Configurer;
class SimulationConfiguration;

class Configurable {
public:
  /** Get this Configurable's configurable subitems. */
  //  virtual vector<Configurer *> &getConfigurers() const = 0;

  virtual void configure( SimulationConfiguration &configuration ) = 0;

  /**
     This is a default implementation that returns an empty vector of
     configurers.
  */
  static vector<Configurer *> &getConfigurersEmpty();

protected:
  Configurable(){}
  virtual ~Configurable(){}
};

#endif

