/* -*- C++ -*-
 
  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
*/

#include <SetupLanguageWindow.h>

#include <Setup.h>
#include <Strings.h>
#include <Schematic.h>
#include <SmithView.h>
#include <MainWindow.h>

#include <qdir.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qapplication.h>
#include <qtranslator.h>
#include <qstringlist.h>
#include <qmessagebox.h>

#include <iostream>
#include <stdlib.h>

using namespace std;

const QString SetupLanguageWindow::englishString = "English";

//----------------------------------------------------------------------------
SetupLanguageWindow::SetupLanguageWindow( QWidget* parent, const char* name )
    : QDialog(parent, name, TRUE),
    isInit_(false),
    topLayout_(0)
{
  setCaption( name );

  topLayout_ = new QVBoxLayout( this );
  QGridLayout* gridLayout = new QGridLayout ( 0 );
  QHBoxLayout* buttonLayout = new QHBoxLayout( 0 );

  topLayout_->addSpacing( 10 );
  topLayout_->addItem( gridLayout );
  topLayout_->addSpacing( 10 );
  topLayout_->addItem( buttonLayout );

  QString okLabel = Strings::translate( Strings::LabelOk );
  QString cancelLabel = Strings::translate( Strings::LabelCancel );
  QPushButton* ok = new QPushButton( okLabel, this );
  QPushButton* cancel = new QPushButton( cancelLabel, this );

  buttonLayout->addWidget( ok );
  buttonLayout->addWidget( cancel );

  connect ( ok, SIGNAL( clicked() ),
            this, SLOT( ok() ) );
  connect ( cancel, SIGNAL( clicked() ),
            this, SLOT( cancel() ) );

  QString labelText = Strings::translate( Strings::LabelLanguage );
  label_ = new QLabel( this );
  label_->setText( labelText );
  edit_ = new QComboBox( this );

  gridLayout->expand( 1, 5 );
  gridLayout->addColSpacing( 0, 30 );
  gridLayout->addColSpacing( 1, 100 );
  gridLayout->addColSpacing( 2, 10 );
  gridLayout->addColSpacing( 3, 100 );
  gridLayout->addColSpacing( 4, 30 );

  gridLayout->addWidget( label_, 0, 1 );
  gridLayout->addWidget( edit_, 0, 3 );

  resize( topLayout_->sizeHint() );
}

//----------------------------------------------------------------------------
SetupLanguageWindow::~SetupLanguageWindow()
{
  delete topLayout_;
}

//----------------------------------------------------------------------------
bool SetupLanguageWindow::init()
{
  if (!isInit_)
    {
      isInit_ = loadLanguages();
    }
  return isInit_;
}

//----------------------------------------------------------------------------
void SetupLanguageWindow::ok()
{
  QString selected = edit_->currentText();
  cout << "Selected language is " << selected << endl;
  QString filename = langFile_[selected];
  Setup::instance()->setLanguageFile( filename );
  close();
  MainWindow::instance()->notifyConfigChange();
}

//----------------------------------------------------------------------------
void SetupLanguageWindow::cancel()
{
  close();
}

//----------------------------------------------------------------------------
bool SetupLanguageWindow::loadLanguages()
{
  const QString& vipecHome = Setup::instance()->vipecHome();
  QDir dir(".");
  QString messageDir = vipecHome + "/messages";
  if (!dir.cd(messageDir))
    {
      QString message = "The messages directory could not be located! ";
      message += "Please ensure that the VIPECHOME environment variable it set.";
      QMessageBox::warning( this, Strings::LabelApplicationName, message );
      return false;
    }
  dir.setNameFilter("*.qm");
  QStringList entryList = dir.entryList();
  edit_->insertItem(englishString);
  for (uint i=0; i<entryList.count(); i++)
    {
      QString filename = entryList[i];
      cout << "Reading file " << filename << endl;
      QTranslator translator( 0 );
      translator.load( filename, messageDir );
      QString langName = translator.find("Strings","LanguageName");
      if (langName != QString::null )
        {
          edit_->insertItem(langName);
          langFile_[langName] = filename;
        }
    }
  return true;
}

