/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TTOSD__MENU__H
#define TTOSD__MENU__H
  
#include <vdr/osd.h>
#include <vdr/osdbase.h>
#include <vdr/status.h>

#include "txtbitmap.h"
#include "txtrecv.h"

extern int Stretch;

class ChannelStatus : public cStatus {
public:
   ChannelStatus();
protected:
   virtual void ChannelSwitch(const cDevice *Device, int ChannelNumber);
};


enum eTeletextAction { Zoom, HalfPage, SwitchChannel,
                       DarkScreen, SuspendReceiving }; //and 100-899 => jump to page
#define LAST_ACTION (int)SuspendReceiving

class TeletextBrowser : public cOsdObject {
public:
   TeletextBrowser(cTxtStatus *txtSt);
   ~TeletextBrowser();
   void Show(void);
   static void ChannelSwitched(int ChannelNumber);
   virtual eOSState ProcessKey(eKeys Key);
protected:
   void SetNumber(int i);
   void ShowPage();
   void UpdateClock();
   bool DecodePage();
   void ChangePageRelative(bool back=false);
   void ChangeSubPageRelative(bool back=false);
   bool CheckPage();
   void ShowAskForChannel();
   void FillFileName(int pageNumber, int subpage);
   void FindFirstSubPage(int startWith);
   void SetPreviousPage(int oldPage, int oldSubPage, int newPage);
   int  PageCheckSum();
   void ShowPageNumber();
   void ExecuteAction(eTeletextAction e);
   char fileName[255];
   char page[40][24];
   int cursorPos;
   cTxtBitmap *txtbitmap;
   cOsdBase *osd;
   eTeletextAction TranslateKey(eKeys Key);
   bool pageFound;
   bool selectingChannel;
   int selectingChannelNumber;
   int checkSum;
   cTxtStatus *txtStatus;
   bool suspendedReceiving;
   int previousPage;
   int previousSubPage;
   static DisplayMode mode;
   static int currentPage;
   static int currentSubPage;
   static int channelNumber;
   static TeletextBrowser* self;
};


#endif

