/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifndef _vdkb_ide_def_h
#define _vdkb_ide_def_h
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>
#include <vdk/vdk.h>
#include <vdkb2/vdkb_types.h>
// default file parser
// sections
#define END_SECTION       "}"
#define EDITOR_SECTION    "vdkb_editor{"
#define UNIT_SECTION      "vdkb_units{"
#define PROJECT_SECTION   "vdkb_project{"
// keys
#define END_KEY             ";"
// editor keys
#define FONT_KEY            "font:"
#define FG_KEY              "fg:"
#define BG_KEY              "bg:"
#define EDITOR_HSIZE_KEY    "h_size:"
#define EDITOR_VSIZE_KEY    "v_size:"

#define EDITOR_KEY_FONT_KEY     "key_font:"
#define EDITOR_KEY_COLOR_KEY     "key_color:"

#define EDITOR_GTK_FONT_KEY     "gtk_font:"
#define EDITOR_GTK_COLOR_KEY     "gtk_color:"


#define EDITOR_MACRO_FONT_KEY     "macro_font:"
#define EDITOR_MACRO_COLOR_KEY     "macro_color:"


#define EDITOR_PREPROCESS_COLOR_KEY "preprocess_color:"
#define EDITOR_PREPROCESS_FONT_KEY "preprocess_font:"

#define EDITOR_CONST_FONT_KEY   "const_font:"
#define EDITOR_CONST_COLOR_KEY   "const_color:"

#define EDITOR_COMMENT_FONT_KEY "comment_font:"
#define EDITOR_COMMENT_COLOR_KEY "comment_color:"

#define EDITOR_KEY_TIMEDSAVE    "timed_save:"
#define EDITOR_KEY_BACKUP       "backup:"
#define EDITOR_KEY_TAB          "tab:"
// unit keys
#define UNIT_COUNT_KEY      "count:"
#define UNIT_NAME_KEY       "name:"
#define UNIT_CC_EXT_KEY     "cc_ext:"
#define UNIT_H_EXT_KEY      "h_ext:"
// project keys
#define PROJECT_COUNT_KEY   "count:"
#define PROJECT_NAME_KEY    "name:"
#define PROJECT_PRJ_EXT_KEY "prj_ext:"
#define PROJECT_HIDE_ON_RUN_KEY "hide_on_run:"
#define PROJECT_AUTOSAVE_KEY "autosave:"
#define PROJECT_STARTUPDIR_KEY "startup_dir:"
#define PROJECT_WI_RESIZEABLE_KEY "wi_resizeable:"
#define PROJECT_WI_LAYOUT_KEY "wi_layout:"
#define PROJECT_VDK_REF_PATH_KEY "vdk_ref_path:"
#define PROJECT_VDK_REF_BROWSER_KEY "vdk_ref_browser:"
#define PROJECT_SAVE_SESSION_KEY "save_session:"
#define PROJECT_CODE_INDENT_KEY "code_indent:"
#define PROJECT_RUN_MODAL_KEY    "run_modal:"
#define PROJECT_EMACS_KEY        "emacs:"
#define PROJECT_THEME_KEY        "theme:"
#define PROJECT_CODE_AUTOINDENT_KEY "code_autoindent:"
#define PROJECT_SHOWLN_KEY          "show_line_numbers:"
#define PROJECT_EXTASCII_KEY   "ext_ascii:"
#define PROJECT_ENABLE_CLASS_BROWSER_KEY   "enable_class_browser:"
// defaults of defaults
// editor
#define EDITOR_DEF_SIZE VDKPoint(500,400)
#define EDITOR_DEF_FONT "courier 12"
#define EDITOR_DEF_FG   "black"
#define EDITOR_DEF_BG   "white"

#define EDITOR_DEF_COMMENT_COLOR "navy blue"
#define EDITOR_DEF_CONST_COLOR  "blue"
#define EDITOR_DEF_KEY_COLOR "brown"
#define EDITOR_DEF_PREPROCESS_COLOR "ForestGreen"
#define EDITOR_DEF_MACRO_COLOR "ForestGreen"
#define EDITOR_DEF_GTK_COLOR "indian red"

#define EDITOR_DEF_COMMENT_FONT "courier 12"
#define EDITOR_DEF_CONST_FONT  "courier 12"
#define EDITOR_DEF_KEY_FONT "courier bold 12"
#define EDITOR_DEF_MACRO_FONT "courier 12"
#define EDITOR_DEF_PREPROCESS_FONT "courier bold 12"
#define EDITOR_DEF_GTK_FONT  "courier 12"

#define EDITOR_DEF_TIMEDSAVE    "0"
#define EDITOR_DEF_BACKUP       "yes"
#define EDITOR_DEF_TAB          "4"
// unit
#define UNIT_DEF_COUNT  1
#define UNIT_DEF_NAME   (char*) "unit"
#define UNIT_DEF_CC_EXT (char*) ".cc"
#define UNIT_DEF_H_EXT  (char*) ".h"
// project
#define PROJECT_DEF_COUNT  1
#define PROJECT_DEF_NAME   (char*) "project"
#define PROJECT_DEF_PRJ_EXT (char*) ".prj"
#define PROJECT_DEF_HIDE_ON_RUN (char*) "no"
#define PROJECT_AUTOSAVE (char*) "no"
#define PROJECT_STARTUPDIR (char*) "home"
#define PROJECT_WI_RESIZEABLE (char*) "no"
#define PROJECT_WI_LAYOUT (char*) "0"
#define PROJECT_VDK_REF_PATH (char*) "?"
#define PROJECT_VDK_REF_BROWSER (char*) "netscape"
#define PROJECT_SAVE_SESSION (char*) "no"
#define PROJECT_CODE_INDENT  (char*) "yes"
#define PROJECT_RUN_MODAL    (char*) "yes"
#define PROJECT_EMACS        (char*) "no"
#define PROJECT_THEME        (char*) "no"
#define PROJECT_CODE_AUTOINDENT (char*) "no"
#define PROJECT_SHOWLN (char*) "no"
#define PROJECT_EXTASCII   (char*) "yes"
#define PROJECT_ENABLE_CLASS_BROWSER   (char*) "no"
/////// for project ///////////////
class VDKBProjectDefaults
{
 public:
  int count;
  VDKString def_name,prj_ext,hide_on_run,
    autosave,startupdir,wi_resizeable,wi_layout,vdk_ref_path,vdk_ref_browser,
    save_session, code_indent, run_modal, emacs,code_autoindent, showln,
    extascii,theme,enable_class_browser;
 public:
  VDKBProjectDefaults():
    count(PROJECT_DEF_COUNT),
    def_name(PROJECT_DEF_NAME),
    prj_ext(PROJECT_DEF_PRJ_EXT),
    hide_on_run(PROJECT_DEF_HIDE_ON_RUN),
    autosave(PROJECT_AUTOSAVE),
    startupdir(PROJECT_STARTUPDIR),
    wi_resizeable(PROJECT_WI_RESIZEABLE),
    wi_layout(PROJECT_WI_LAYOUT),
    vdk_ref_path(PROJECT_VDK_REF_PATH),
    vdk_ref_browser(PROJECT_VDK_REF_BROWSER),
    save_session(PROJECT_SAVE_SESSION),
    code_indent(PROJECT_CODE_INDENT),
    run_modal(PROJECT_RUN_MODAL),
    emacs(PROJECT_EMACS),
    code_autoindent(PROJECT_CODE_AUTOINDENT),
    showln(PROJECT_SHOWLN),
    extascii(PROJECT_EXTASCII),
    theme(PROJECT_THEME),
    enable_class_browser(PROJECT_ENABLE_CLASS_BROWSER)
    {}
  void LoadDefaults(char* section);
  ~VDKBProjectDefaults() {}
};
/////// for editor ////////////////

class VDKBEditorDefaults
{
 public:  
  VDKString font, fg, bg;
  VDKPoint  size;
  VDKString 
    key_font,key_color,
    gtk_font,gtk_color,
    macro_font,macro_color,
    preprocess_font, preprocess_color,
    const_font,const_color,
    comment_font,comment_color,
    timedsave,backup, tab;
 public:
  VDKBEditorDefaults(): 
    font(EDITOR_DEF_FONT), 
    fg(EDITOR_DEF_FG), 
    bg(EDITOR_DEF_BG),
    size(EDITOR_DEF_SIZE),

    key_font(EDITOR_DEF_KEY_FONT),
    key_color(EDITOR_DEF_KEY_COLOR),
    gtk_font(EDITOR_DEF_GTK_FONT),
    gtk_color(EDITOR_DEF_GTK_COLOR),
    macro_font(EDITOR_DEF_MACRO_FONT),
    macro_color(EDITOR_DEF_MACRO_COLOR),
    preprocess_font(EDITOR_DEF_PREPROCESS_FONT),
    preprocess_color(EDITOR_DEF_PREPROCESS_COLOR),
    const_font(EDITOR_DEF_CONST_FONT),
    const_color(EDITOR_DEF_CONST_COLOR),
    comment_font(EDITOR_DEF_COMMENT_FONT),
    comment_color(EDITOR_DEF_COMMENT_COLOR),

    timedsave(EDITOR_DEF_TIMEDSAVE),
    backup(EDITOR_DEF_BACKUP),
    tab(EDITOR_DEF_TAB)
    {}
  void LoadDefaults(char* section);
  ~VDKBEditorDefaults() {}
};
///// for units ///////////////
class VDKBUnitDefaults
{
 public:
  int count;
  VDKString def_name,cc_ext,h_ext;
 public:
  VDKBUnitDefaults():
    count(UNIT_DEF_COUNT),
    def_name(UNIT_DEF_NAME),
    cc_ext(UNIT_DEF_CC_EXT),
    h_ext(UNIT_DEF_H_EXT) {}
  void LoadDefaults(char* section);
  ~VDKBUnitDefaults() {}
};
////////// all defaults /////////////
class VDKBDefaults
{
  VDKString rcFile;
 public:
  VDKBEditorDefaults editor;
  VDKBUnitDefaults unit;
  VDKBProjectDefaults project;
  //
  VDKBDefaults(char* resFile = NULL);
  void LoadDefaults(char* home);
  ~VDKBDefaults() {}
};
////////
#endif
