/***************************************************************************
                          dctranslator.h  -  description
                             -------------------
    begin                : Die Nov 19 2002
    copyright            : (C) 2002 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCTRANSLATOR_H
#define DCTRANSLATOR_H

#include <qobject.h>
#include <dclib/core/cstringlist.h>

/**
  *@author Mathias Kster
  */

class QUrlOperator;
class QNetworkOperation;

class DCTranslator : public QObject  {
Q_OBJECT

public: 
	/** construtor */
	DCTranslator(QWidget *parent=0, const char *name=0);
	/** destructor */
	virtual ~DCTranslator();

	/** */
	void InitDocument();

	/** */
	QString SelectLanguage( CString lang );
	/** */
	bool Translate( QObject * sender, QString lang, QString text );

private:
	/** */
	QUrlOperator * pOp;
	/** */
	CStringList m_UrlList;
	/** */
	QString m_sLanguage;

private slots:
	/** */
	void slotData( const QByteArray & data, QNetworkOperation * op );
	/** */
	void slotDataTransferProgress( int bytesDone, int bytesTotal, QNetworkOperation * op );
	/** */
	void slotFinished( QNetworkOperation * op );

};

extern DCTranslator * g_pTranslator;
#endif
