/* $Id: misc.c,v 1.7 2002/10/30 00:23:37 bjk Exp $ */
/*
    Copyright (C) 2001-2002  Ben Kibbey <bjk@arbornet.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <time.h>
#include "common.h"

#ifndef HAVE_ERR_H
#include "err.c"
#endif

#ifndef HAVE_STRSEP
#include "strsep.c"
#endif

void *Calloc(size_t num, size_t size)
{
    void *ptr;

    if ((ptr = calloc(num, size)) == NULL)
	err(EXIT_FAILURE, "%s", "calloc()");

    return ptr;
}

void *Malloc(size_t size)
{
    void *ptr;

    if ((ptr = malloc(size)) == NULL)
	err(EXIT_FAILURE, "%s", "malloc()");

    return ptr;
}

char *stamp(time_t epoch, const char *format)
{
    static char buf[TIMEBUFSIZE];
    struct tm *t;

    t = localtime(&epoch);
    strftime(buf, sizeof(buf), format, t);

    return buf;
}

/* remove characters (rm) from string (str) */
char *stripstr(char *str, char *rm)
{
    static char buf[LINE_MAX];
    char *orm;
    int i = 0, c;

    if (rm == NULL || str == NULL)
	return str;

    while (*str) {
	orm = rm;

	while (*orm) {
	    if (*str == *orm) {
		c = *str++;
		continue;
	    }

	    c = *orm++;
	}

	buf[i++] = *str++;
    }

    buf[i] = 0;
    return buf;
}
