#! /bin/sh 
# test update-cluster-remove operation.
set -ex

[ "`./update-cluster-remove --ip 192.168.0.2  < ${srcdir}/test/input.xml`" = "\
<?xml version =\"1.0\"?>
<!DOCTYPE cluster SYSTEM \"${pkgdatadir}/cluster.dtd\">
<cluster>
  <host>
    <ip>192.168.0.1</ip>
    <hostname>undermade</hostname>
    <mac>11:22:33:44:55:66</mac>
    <notes>master</notes>
  </host>
  <host>
    <ip>192.168.0.3</ip>
    <hostname>somer2</hostname>
    <mac>22:33:44:55:66:99</mac>
  </host>
</cluster>" ]

[ "`./update-cluster-remove --mac 11:22:33:44:55:66  < ${srcdir}/test/input.xml`" = "\
<?xml version =\"1.0\"?>
<!DOCTYPE cluster SYSTEM \"${pkgdatadir}/cluster.dtd\">
<cluster>
  <host>
    <ip>192.168.0.2</ip>
    <hostname>somer</hostname>
    <mac>22:33:44:55:66:77</mac>
  </host>
  <host>
    <ip>192.168.0.3</ip>
    <hostname>somer2</hostname>
    <mac>22:33:44:55:66:99</mac>
  </host>
</cluster>" ]

[ "`./update-cluster-remove --not --mac 11:22:33:44:55:66  < ${srcdir}/test/input.xml`" = "\
<?xml version =\"1.0\"?>
<!DOCTYPE cluster SYSTEM \"${pkgdatadir}/cluster.dtd\">
<cluster>
  <host>
    <ip>192.168.0.1</ip>
    <hostname>undermade</hostname>
    <mac>11:22:33:44:55:66</mac>
    <notes>master</notes>
  </host>
</cluster>" ]
