#ifndef _uctlmenu_hpp_
#define _uctlmenu_hpp_
#include <ubit/umenu.hpp>

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

class UCtlmenu : public UPopmenu {
public:

  struct Action {
    virtual ~Action() {}
    virtual void select(UEvent&, UCtlmenu&)   {}
    virtual void mdrag(UEvent&, UCtlmenu&)    {}
    virtual void postdrag(UEvent&, UCtlmenu&) {}
    virtual void mrelease(UEvent&, UCtlmenu&) {}
  };

  UCtlmenu(const UArgs& a = UArgs::none);
  virtual ~UCtlmenu() {}

  virtual void autoOpens(UBox& opener, u_id buttons, u_id keysym,
                         bool active_on_children);
  virtual void autoOpens(UBox& opener,
                         const std::vector<UPopmenu::InputCond>&,
                         bool active_on_children);
    
  virtual void setAction(int no, UBox& item, UCtlmenu::Action& a);
  virtual void postpone(UCtlmenu::Action*);
  
  UGroup* getOpenSource() const {return open_source;}
  u_pos getXselect() const {return xselect;}
  u_pos getYselect() const {return yselect;}

protected:
  Action *op, *postponed_op;
  Action* actions[8];
  UTrow* rows[3];
  uptr<UTimer> timer;
  UGroup* open_source;
  u_pos xselect, yselect;

  void init();
  virtual void autoOpenImpl(UEvent&);
  // function called by autoOpens() when the menu pops up.

  void reset(UEvent&);
  void select(UEvent&, UCtlmenu::Action*);
  void mdrag(UEvent&);
  void mrelease(UEvent&);
  void timeout(UEvent&);
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
