/* ==================================================== ======== ======= *
 *
 *  dselect.cc  [demo]
 *  Ubit Project [Elc::00]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2000 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:00] ======= *
 * ==================================================== ======== ======= */


#include <ubit/ubit.hpp>
#include "dmisc.hh"
#include "dselect.hh"


void SelectDialog::changedCB(UEvent& e) {
  selectedBox = radio->getItem();
  if (selectedBox) *message = selectedBox->copyText(false);
}

/* ==================================================== [Elc:00] ======= */
/* ==================================================== ======== ======= */

SelectDialog::SelectDialog() {

  radio = &uradioSelect();
  message = &ustr("");

  // add a callback method to the uradio:
  // (note: we could either add a callback function)
  radio->onChange(ucall(this, &SelectDialog::changedCB));

  UVbox &part0 =
    uvbox(UBorder::etchedOut + uhflex() + utop()
	  + ulabel(UBgcolor::white + "RadioBoxes:")
	  + uhbox(
		  uvbox(UBorder::etchedOut
			+ UFont::small
			+ ucheckbox("One" + *radio)
			+ ucheckbox("Two" + *radio)
			+ ucheckbox("Three" + *radio)
			+ ucheckbox("Four" + *radio)
		     )
		  + ubutton(UOrient::vertical
			    + "A Button containing"
			    + "exclusive checkboxes"
			    + uvbox( ucheckbox("Five" + *radio)
				     + ucheckbox("Six" + *radio)
				     + ucheckbox("Seven" + *radio)
				     )
			    )
		  )

	  + uvflex()
	  + uflowbox(uedit() + UBgcolor::wheat + UBorder::shadowIn
		  + "Warped editable text containing exclusive checkboxes "
		  + ucheckbox("Eight" + *radio) + " and "
		  + ucheckbox("Nine" + *radio) + " and "
		  + ucheckbox("Ten" + *radio) + "blah blah..."
		  )
	  );


  UVbox &part1 =
    uvbox(UBorder::etchedIn + uhflex() + utop()
	  + ulabel(UBgcolor::white + "Scrolled List 1:")
	  + uvflex() + uhflex()
	  + uscrollpane(true, false,
			UBorder::etchedOut
			+ uvbox(ubutton("one" + *radio)
				+ ubutton("two" + *radio)
				+ ubutton("three" + *radio)
				+ ubutton("four" + *radio) 
				+ uhbox(ubutton(ubit_pix + "uuu" + *radio)
					+ubutton(UPix::ray +"ray" + *radio)
					+ubutton(eyes_pix + "eyes" + *radio)
					)
				+ utextbox(*radio + uedit() + UColor::orange+ "editable text")
				+ ubutton("five" + *radio) 
				+ ubutton("six" + *radio )
				+ ubutton("eight"+ *radio) 
				+ ubutton("nine"+ *radio) 
				+ ubutton("ten" + *radio) 
				+ ubutton("eleven" + *radio) 
				+ ubutton("twelve" + *radio) 
				)
			)
	  );

  UVbox &part2 =
    uvbox( UBorder::etchedIn + uhflex() + utop()
	  + ulabel(UBgcolor::white + "Scrolled List 2:")
	  + uvflex() + uhflex()
	  + uscrollpane(true, false,
			UBorder::etchedOut
			+ uvbox(ulabel("one" + *radio)
				+ ulabel("two" + *radio)
				+ ulabel("three" + *radio)
				+ ulabel("four" + *radio) 
				+ uhbox(ulabel("imbricated" + *radio ) 
					+ulabel("horizontal" + *radio ) 
					+ulabel("list" + *radio ) 
					)
				+ uhbox(ulabel("aaaaaa" + *radio ) 
					+ulabel("bbbbbb" + *radio ) 
					+ulabel("cccccc" + *radio ) 
					)
				+ uhbox(ulabel(uedit() + "editable" + *radio ) 
					+ulabel(uedit() + "selectable" + *radio ) 
					+ulabel(uedit() + "items" + *radio ) 
					)
				+ uhbox(ubutton("imbricated" + *radio ) 
					+ubutton("button" + *radio ) 
					+ubutton("list" + *radio )
					)
				+ ulabel("five" + *radio) 
				+ ulabel("six" + *radio ) 
				+ ulabel("eight"+ *radio) 
				+ ulabel("nine"+ *radio) 
				+ ulabel("ten" + *radio) 
				+ ulabel("eleven" + *radio) 
				+ ulabel("twelve" + *radio) 
				)
			)
		  );


  //adds children to "this" object (= the Dialog)
  addlist
    (
     utitle("Selection") + uheight(250)
     + ulabel(UBorder::etchedOut + UFont::bold 
	      + UFont::italic +UColor::red
	      + "All items are mutually exclusive !")
     + uvflex() + uhflex()
     + uhbox(uhflex() + uvflex() + part0 + part1 + part2)
     
     + ubottom()
       + ulabel("")
     + utextbox("selected value = " + *message)
     + uhbox(UBorder::shadowIn 
	     // closes the dialog box when the Close button is pressed
	     + ubutton(UFont::bold + "Close" + ucloseWin())
	     )

     );
};


/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:00] ======= */
