//
//
//  Test.cc
//
//  This is a test to verify correct compilation of the cppunit stuff
//
//

#include "main.hh"

// CppUnit Headers
#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "tyvis/vhdl.hh"
#include <warped/WarpedMain.h>

// Add test case headers here
#include "ArrayTypeTest.hh"
#include "ArrayTypeInfoTest.hh"
#include "BlockTest.hh"
#include "EnumerationTypeTest.hh"
#include "FileOpenKindTest.hh"
#include "FileOpenStatusTest.hh"
#include "SeverityLevelTest.hh"
#include "SharedFileEventTest.hh"
#include "SigEventTest.hh"
#include "SignalTest.hh"
#include "UniversalBooleanTest.hh"
#include "UniversalCharacterTest.hh"
#include "UniversalIntegerTest.hh"
#include "UniversalLongLongIntegerTest.hh"
#include "UniversalRealTest.hh"
#include "WaitEventTest.hh"

// Add your tests to the suite here
CPPUNIT_TEST_SUITE_REGISTRATION( ArrayTypeTest );
CPPUNIT_TEST_SUITE_REGISTRATION( ArrayTypeInfoTest );
CPPUNIT_TEST_SUITE_REGISTRATION( BlockTest );
CPPUNIT_TEST_SUITE_REGISTRATION( EnumerationTypeTest );
CPPUNIT_TEST_SUITE_REGISTRATION( FileOpenKindTest );
CPPUNIT_TEST_SUITE_REGISTRATION( FileOpenStatusTest );
CPPUNIT_TEST_SUITE_REGISTRATION( SeverityLevelTest );
CPPUNIT_TEST_SUITE_REGISTRATION( SharedFileEventTest );
CPPUNIT_TEST_SUITE_REGISTRATION( SignalTest );
CPPUNIT_TEST_SUITE_REGISTRATION( SigEventTest );
CPPUNIT_TEST_SUITE_REGISTRATION( UniversalBooleanTest );
CPPUNIT_TEST_SUITE_REGISTRATION( UniversalCharacterTest );
CPPUNIT_TEST_SUITE_REGISTRATION( UniversalIntegerTest );
CPPUNIT_TEST_SUITE_REGISTRATION( UniversalLongLongIntegerTest );
CPPUNIT_TEST_SUITE_REGISTRATION( UniversalRealTest );
CPPUNIT_TEST_SUITE_REGISTRATION( WaitEventTest );

int main() { 
  WarpedMain::registerKernelDeserializers();
  registerTyvisDeserializers();

  CppUnit::TextUi::TestRunner runner;
  CppUnit::TestFactoryRegistry &registry = CppUnit::TestFactoryRegistry::getRegistry();
  runner.addTest(registry.makeTest());
  bool result =  runner.run();

  return result;
}
