//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef VHDL_HH
#define VHDL_HH

#include "tyvis/Types.hh"

class VHDLKernel;

//===========================================================================
// sensitivity list & wait resumption stuff
#define FILE_DELIMITER '|'

//===========================================================================
// Signal association data structure

struct Association_t {
  int sig;
  int src;
};

inline ostream& operator<<(ostream& os, const Association_t& a) {
  os << a.sig << "(" << a.src << ")";
  return os;
}




void registerTyvisDeserializers();



#endif
