#include "UniversalBoolean.hh"
#include "AccessVariable.hh"
#include "AccessType.hh"
#include "ArrayType.hh"
#include "std_standardPkg.hh"
#include <sstream>
using std::ostringstream;
using std::stringstream;

UniversalBoolean
UniversalBoolean::vhdlAnd( const UniversalBoolean &rhs ) const {
  return UniversalBoolean(val && rhs.val);
}

UniversalBoolean
UniversalBoolean::vhdlOr( const UniversalBoolean &rhs ) const {
  return UniversalBoolean(val || rhs.val);
}

UniversalBoolean
UniversalBoolean::vhdlNand( const UniversalBoolean &rhs ) const {
  return UniversalBoolean(!(val && rhs.val));
}

UniversalBoolean
UniversalBoolean::vhdlNor( const UniversalBoolean &rhs ) const {
  return UniversalBoolean(!(val||rhs.val));
}

UniversalBoolean
UniversalBoolean::vhdlXor( const UniversalBoolean &rhs ) const {
  return UniversalBoolean(val != rhs.val);
}

UniversalBoolean
UniversalBoolean::vhdlXnor( const UniversalBoolean &rhs ) const {
  return UniversalBoolean(val == rhs.val);
}

UniversalBoolean
UniversalBoolean::vhdlNot() const {
  return UniversalBoolean(!val);
}

UniversalBoolean::UniversalBoolean( const VHDLData &v ){
  operator=(v);
}

int
UniversalBoolean::savantwrite(AccessVariable &line) const {
  ostringstream tempStr;
  
  tempStr << line.getVal() << (int)val << FILE_DELIMITER << '\0';
  line.setVal( tempStr.str() );

  return NORMAL_RETURN;
}

int
UniversalBoolean::savantwrite(AccessType &line) const {
  ostringstream tempStr;
  if (line.val != NULL) {
    tempStr << line << (int)val << FILE_DELIMITER << '\0';
  }
  else {
    tempStr << (int)val << FILE_DELIMITER << '\0';
  }
  
  if (line.val != NULL) {
    delete line.val;
  }
  
  line.val = new ArrayType( ObjectBase::VARIABLE,
			    SavantstringType_info,
			    -1,
			    tempStr.str().c_str() );

  return NORMAL_RETURN;
}

int
UniversalBoolean::savantread(AccessVariable &) {
  return NORMAL_RETURN;
}

int
UniversalBoolean::savantread(AccessType &line) {
  char *workString = line.val->getString();
  char *input      = new char[strlen(workString) + 1];
  stringstream inputStream;
  
  extractToDelimiter( workString, FILE_DELIMITER, input );
  
  int tempInt;

  inputStream << input;
  inputStream >> tempInt;

  if (tempInt == 1) {
    val = true;
  }
  else {
    val = false;
  }
  
  delete line.val;

  if (strlen(workString) > 0) {
    line.val = new ArrayType(ObjectBase::VARIABLE, SavantstringType_info, -1, workString);
  }
  else {
    line.val = NULL;
  }

  delete workString;
  delete input;
  
  return NORMAL_RETURN;
}
