//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef _ELEMENT_ASSOCIATION_HH
#define _ELEMENT_ASSOCIATION_HH

#include "tyvis/ArrayInfo.hh"
#include "tyvis/VHDLType.hh"
#include "tyvis/UniversalInteger.hh"

class ElementAssociation {
public:
  ArrayInfo choice;
  VHDLType* value;
  ElementAssociation(): choice(Others), value(NULL) { }

  ElementAssociation(ArrayInfo a, VHDLType* v): choice(a), value(v) { }

  ElementAssociation( int position, VHDLType *v ): 
    choice(position, ArrayInfo::to, position),
    value(v) {}
  
  ElementAssociation(int position, VHDLType &v):
    choice(position, ArrayInfo::to, position),
    value(&v){ }

  ElementAssociation(UniversalInteger position, VHDLType* v): 
                     choice(position.getValue(), ArrayInfo::to, position.getValue()),
		     value(v) {}
};

#endif //ifndef _ELEMENT_ASSOCIATION_HH
