
#include "userif.h"
#include <stdio.h>
//#include <stdlib.h>
#include <unistd.h>
#include <string.h>
//#include <pthread.h>
#include <errno.h>
#include <sys/socket.h>
//#include <sys/types.h>
//#include <sys/stat.h>
#include <sys/un.h>
#include <netinet/in.h>
//#include <sys/time.h>
//#include <fcntl.h>
//#include <sys/ioctl.h>


#include "psk31-coder.h"
#include "psk31-receiver.h"
#include "psk31-transmitter.h"


int SocketComm::init() {
	psk31_coder::init_tables();
	psk31rx = new psk31_receiver();
	psk31tx = new psk31_transmitter();
	return 0;
}


int SocketComm::init_unix(char *unix_path) {
	struct sockaddr_un saddr;
	if( (sockfd=socket(PF_UNIX, SOCK_STREAM, 0))<0 )
		return -1;
	saddr.sun_family = AF_UNIX;
	strncpy(saddr.sun_path, unix_path, sizeof(saddr.sun_path));
	if( connect(sockfd, (struct sockaddr *)&saddr, sizeof(saddr)) ) {
		sockfd = -1;
		return -1;
	}
}

int SocketComm::fdread(char *data, int count) {
}

int SocketComm::fdwrite(char *data, int count) {
	int res;
	while(1) {
		res=write(sockfd, data, count);
		if(res<0 && errno==EINTR) continue;
		else if(res<0) return -1;
		else if(res<count) {
			data += res;
			count -=res;
			continue;
		}
		return 0;
	}
}

int SocketComm::txBufferAppend(char *data, int count) {
	char buf[2]; 
	if(count=0) count=strlen(data);
	short len=htons((unsigned short)count);
	buf[0] = TX_DATA;
	buf[1] = 0;  // channel;
	if( fdwrite(buf,2)<0 ) return -1;
	if( fdwrite((char *)&len,2)<0 ) return -1;
	if( fdwrite(data,count)<0) return -1;
	if( fdread(buf,2)<0 ) return -1;
	if( fdread((char *)&len,2)<0 ) return -1;
	if( buf[0]!=~TX_DATA ) {
		fprintf(stderr,"protocol error on socket\n");
		return -2;
	}
	return ntohs(len);
}


int SocketComm::txBufferHasSpace() {
	char buf[2];
	buf[0] = TX_HASSPACE;
	buf[1] = 0;
	if( fdwrite(buf,2)<0 ) return -1;
	if( fdread(buf,2)<0 ) return -1;
	if( buf[0]!=~TX_HASSPACE ) {
		fprintf(stderr,"protocol error on socket\n");
		return -2;
	}
	return (int)buf[1];
}

int SocketComm::txControl(int cmd, void *arg, int arglen) {
	char buf[2];
	short len;
	buf[0] = CONTROL;
	buf[1] = cmd;
	len = htons((short)arglen);
	if( fdwrite(buf,2)<0 ) return -1;
	if( fdwrite((char *)&len,2)<0 ) return -1;
	if( fdwrite((char *)arg,arglen)<0 ) return -1;

	if( fdread(buf,2)<0 ) return -1;
	if( buf[0]!=~CONTROL ) {
		fprintf(stderr,"protocol error on socket(3)\n");
		return -2;
	}
	if( fdread((char *)&len,2)<0 ) return -1;
	if( ntohs(len)!=(short)arglen ) {
		fprintf(stderr,"protocol error on socket(4)\n");
		return -2;
	}
	if( fdread((char *)arg, arglen)<0 ) return -1;
}
int SocketComm::rxBufferGet(int channel, int count, char *data) {
	char buf[2];
	short len = htons((short)count);
	buf[0] = RX_DATA;
	buf[1] = channel;
	if( fdwrite(buf,2)<0 ) return -1;
	if( fdwrite((char *)&len,2)<0 ) return -1;
	if( fdread(buf,2)<0 ) return -1;
	if( buf[0]!=~RX_DATA ) {
		fprintf(stderr,"protocol error on socket(5)\n");
		return -2;
	}
	if( fdread((char *)&len,2)<0 ) return -1;
	if( ntohs(len)>count ) {
		fprintf(stderr, "protoval error on socket(6)\n");
		return -2;
	}
	count = ntohs(len);
	if( fdread(data, count)<0 ) return -1;
	return count;
}
int SocketComm::rxControl(int cmd, void *arg, int arglen) {
	txControl(cmd, arg, arglen);
}
int SocketComm::config(int cmd, void *arg, int arglen) {
	txControl(cmd, arg, arglen);
}

