/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OUTPUTCONTROL_H
#define OUTPUTCONTROL_H

#include "dirs.H"
#include "lektion.h"
#include <wx/wx.h>

class TtOutputControl : public wxTextCtrl {
public:
  TtOutputControl(wxWindow *parent);
  ~TtOutputControl();

  void onSetFocus(wxFocusEvent& event);
  void onMouse(wxMouseEvent& event);

  void Clear();
  
  void setFont (wxFont& newFont);
  inline wxFont* getFont () { return localfont; };

  bool LoadLesson (UrlFile& lesson);
  void highlightFirstChar ();
  void highlightNextChar (unsigned int i = 1, bool newline = false);
  long getHighlightPosition () { return this->highlightCharPos; };

  wxUChar getSpecialLineEnd () { return this->specialLineEnd; };
/*   void highlightChar (unsigned long line, unsigned long column); */
/*   long XYToPosition(long column, long line); */

  void fillFromCache ();
  void updateHighlightPos ();
  void SetSelection(long from, long to);

private:
  wxFont* localfont;
  wxColour* textcolor;
  wxColour* bgcolor;

  long highlightCharPos;
  wxUChar specialLineEnd;

  void highlightChar ();
  void updateLook ();

  DECLARE_EVENT_TABLE()
};

#endif
