/*  XGDVI
 *  Copyright (C) 1999-2001  Hirotsugu Kakugawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "../config.h"

#include <stdio.h>
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
#  include <unistd.h>
#endif
#if HAVE_STRING_H
#  include <string.h>
#endif
#if HAVE_STRINGS_H
#  include <strings.h>
#endif

#include <dvi-2_6.h>
#include <gtk/gtk.h>

#include "defs.h"
#include "xgdvi.h"
#include "files.h"
#include "buff.h"
#include "state.h"
#include "gui.h"
#include "path.h"


void
state_restore(void)
{
  FILE  *fp, *xfp;
  char   buff[1024];
  int    arg_i1, arg_i2;
  double arg_f1, arg_f2, arg_f3;
  char   arg_s1[1024], arg_s2[1024];
  char  *file, *key, *arg, *p;

  if (param_no_state == 1)
    return;

  file = g_strdup_printf("%s%s%s%s%s", 
			 g_get_home_dir(), "/", XGDVI_PERSONAL_DIR, 
			 "/", XGDVI_STATE);

  if ((fp = fopen(file, "r")) == NULL)
    goto Finish;

  while (fgets(buff, sizeof(buff)-1, fp) != NULL){
    if ((p = strchr(buff, '\n')) != NULL)
      *p = '\0';
    if ((p = strchr(buff, ':')) == NULL)
      continue;
    *p = '\0';
    key = buff;
    arg = p+1;
    if (strcmp(key, "xgdvi") == 0){
      if (sscanf(arg, "%s", arg_s1) != 1)
	continue;
      if (strcmp(arg_s1, VERSION) != 0)
	goto Finish;
    } else if (strcmp(key, "buffer") == 0){
      if (sscanf(arg, "%d%s%d%lf%lf%lf%s", 
		 &arg_i1, arg_s1, &arg_i2,
		 &arg_f1, &arg_f2, &arg_f3, arg_s2) != 7)
	continue;
      if ((xfp = fopen(arg_s2, "r")) == NULL)
	continue;
      fclose(xfp);
      xfp = NULL;
#if 0
    printf("RD %s\n", arg_s2);
#endif
      find_file_no_select(g_strdup(arg_s2), arg_i1, paper_id(arg_s1), arg_i2);
    }
  }

Finish:
  if (fp != NULL)
    fclose(fp);
  fp = NULL;
  g_free(file);
  file = NULL;

#if 0
  printf("* state restored\n");
  buffer_dump();
#endif
}


void
state_save(void)
{
  FILE   *fp;
  double  f_shrink, f_view_x, f_view_y;
  int     f_page, f_paper, f_orient;
  char   *p_name;
  char   *f, *file, *f1, *f2;
  int     i;

  if (param_no_state == 1)
    return;

  buffer_save_current_state();

  f1 = g_strdup_printf("%s%s%s%s%s", 
		       g_get_home_dir(), "/", XGDVI_PERSONAL_DIR, 
		       "/", XGDVI_STATE);

  f2 = g_strdup_printf("%s.bak", f1);
  unlink(f2);
  rename(f1, f2);

  fp = fopen(f1, "w");
  if (fp == NULL){
    fprintf(stderr, "xgdvi: cannot save sate\n");
    unlink(f1);
    free(f1);
    free(f2);
    return;
  }

  fprintf(fp, "xgdvi: %s\n", VERSION);

  for (i = 0; ; i++){
    if ((f = buffer_file_name(i, &f_page, &f_paper, &f_orient, 
			      &f_shrink, &f_view_x, &f_view_y)) == NULL)
      break;
    if (g_path_is_absolute(f)){
      file = g_strdup(f);
    } else {
      file = path_canonical(f);
    }
#if 0
    printf("WR %s\n", file);
#endif
    if ((p_name = paper_name(f_paper)) == NULL)
      p_name = PAPER_SIZE;
    fprintf(fp, "buffer: %d %s %d %.2f %.2f %.2f %s\n", 
	    f_page, p_name, f_orient, f_shrink, f_view_x, f_view_y, file);
    g_free(file);
    file = NULL;
  }

  fclose(fp); fp = NULL;
  g_free(f1); f1 = NULL;
  g_free(f2); f2 = NULL;
}

