//----------------------------------------------------
// Originally Created with Truevision, version 0.3.10
// Adapted for Terraform 0.8.6
//----------------------------------------------------
// Copyright (c) Raymond Ostertag
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//----------------------------------------------------

//---------------------------------------------
//  Parameters
//---------------------------------------------

#local SCALE_pigment = 25 ; //global scale for the textures
#local TF_scale = <1/TF_X_SCALE, 1/TF_Y_SCALE, 1/TF_Z_SCALE> * SCALE_pigment ;

#local SCALE_normal = 1 ; // global scale for the bump mapping
#local TF_bumpyscale = <1/TF_X_SCALE, 1/TF_Y_SCALE, 1/TF_Z_SCALE> * SCALE_normal ;

#local DEPTH_bump = 0.5 ; // global scale for the depth of the bump mapping

//---------------------------------------------
//  Basic Textures
//---------------------------------------------

#declare N_Grass = 
		normal {
			wrinkles
			bump_size 0.600000 * DEPTH_bump
			translate <0.000000,0.000000,0.000000> 
			scale <0.005000,0.005000,0.005000> * TF_bumpyscale
			rotate <0.000000,0.000000,0.000000>
		}

#declare F_Grass = 
		finish {
			ambient rgb<0.100000,0.100000,0.100000>
			diffuse 0.600000
			brilliance 1.000000
			phong 0.000000
			phong_size 40
			specular 0.000000
			roughness 0.500000
			metallic 0.000000
			reflection rgb<0.000000,0.000000,0.000000>
			reflection_exponent 1.000000
		}

#declare Rock = 
	texture {
		pigment {
			granite
			color_map {
				[ 0.019791 rgbft<0.550000,0.550000,0.550000,0.000000,0.000000> ]
				[ 0.200000 rgbft<0.549020,0.549020,0.549020,0.000000,0.000000> ]
				[ 0.867708 rgbft<0.430000,0.430000,0.430000,0.000000,0.000000> ]
				[ 1.001000 rgbft<0.247059,0.247059,0.247059,0.000000,0.000000> ]
			}
			translate <0.000000,0.000000,0.000000> 
			scale <0.050000,0.050000,0.050000> * TF_scale
			rotate <0.000000,0.000000,0.000000>
		}
		normal {
			granite
			bump_size 0.500000 * DEPTH_bump
			translate <0.000000,0.000000,0.000000> 
			scale <0.050000,0.050000,0.050000> * TF_bumpyscale 
			rotate <0.000000,0.000000,0.000000>
		}
		finish {
			ambient rgb<0.100000,0.100000,0.100000>
			diffuse 0.600000
			brilliance 1.000000
			phong 0.000000
			phong_size 40
			specular 0.000000
			roughness 0.150000
			metallic 0.000000
			reflection rgb<0.000000,0.000000,0.000000>
			reflection_exponent 1.000000
		}
	}

#declare F_Snow = 
		finish {
			ambient rgb<0.200000,0.200000,0.200000>
			diffuse 0.800000
			brilliance 1.000000
			phong 0.000000
			phong_size 40
			specular 0.000000
			roughness 0.250000
			metallic 0.000000
			reflection rgb<0.150000,0.150000,0.150000>
			reflection_exponent 1.000000
		}

#declare Snow = 
	texture {
		pigment {
			leopard
			color_map {
				[ 0.000000 rgbft<1.000000,1.000000,1.000000,0.000000,0.000000> ]
				[ 1.000000 rgbft<0.930000,0.930000,0.930000,0.000000,0.000000> ]
			}
			
		 turbulence <5.000000,5.000000,5.000000>
		 octaves 6
		 lambda 2.000000
		 omega 0.500000 
		 translate <0.000000,0.000000,0.000000> 
		 scale <0.010000,0.010000,0.010000> * TF_scale
		 rotate <0.000000,0.000000,0.000000>
		}
		finish {
			F_Snow
		}
	}


//---------------------------------------------
//  Sub Textures
//---------------------------------------------

#local Mix_up = <3.0, 1.5, 2.2> ; //control the XZ size of the spot snow-rock
#local Mix_down = <0.5, 0.5, 0.5> ; //control the XZ size of the spot grass-rock

// Rock covered by a lot of grass snow spotted
#declare Rock_grass_snow =
	texture {
		Rock
	}

	texture {
		pigment {
			wrinkles
			color_map {
				[ 0.650000 rgbft<0.080000,0.600000,0.250000,0.000000,0.000000> ]
				[ 0.700000 rgbft<0.008000,0.600000,0.250000,0.800000,0.000000> ]
				[ 0.950000 rgbft<0.080000,0.600000,0.250000,1.000000,0.000000> ]
				[ 1.000000 rgbft<0.080000,0.600000,0.250000,1.000000,0.000000> ]
			}
			translate <0.000000,0.000000,0.000000> 
			scale Mix_down * TF_scale 
			rotate <0.000000,0.000000,0.000000>
		}
		normal {
			N_Grass
		}
		finish {
			F_Grass
		}
	}

	texture {
		pigment {
			wrinkles
			color_map {
				[ 0.250000 rgbft<1.000000,1.000000,1.000000,0.000000,0.000000> ]
				[ 0.300000 rgbft<1.000000,1.000000,1.000000,0.800000,0.000000> ]
				[ 0.400000 rgbft<1.000000,1.000000,1.000000,1.000000,0.000000> ]
				[ 1.000000 rgbft<1.000000,1.000000,1.000000,1.000000,0.000000> ]
			}
			translate <0.000000,0.000000,0.000000> 
			scale Mix_down * TF_scale 
			rotate <0.000000,0.000000,0.000000>
		}
		finish {
			F_Snow
		}
	}

// Rock covered by a lot of snow with a border of grass
#declare Rock_grass_snow2 =
	texture {
		Rock
	}

	texture {
		pigment {
			wrinkles
			color_map {
				[ 0.650000 rgbft<0.080000,0.600000,0.250000,0.000000,0.000000> ]
				[ 0.750000 rgbft<0.008000,0.600000,0.250000,0.800000,0.000000> ]
				[ 0.950000 rgbft<0.080000,0.600000,0.250000,1.000000,0.000000> ]
				[ 1.000000 rgbft<0.078431,0.596078,0.247059,1.000000,0.000000> ]
			}
			translate <0.000000,0.000000,0.000000> 
			scale Mix_up * TF_scale 
			rotate <0.000000,0.000000,0.000000>
		}
		normal {
			N_Grass
		}
		finish {
			F_Grass
		}
	}

	texture {
		pigment {
			wrinkles
			color_map {
				[ 0.600000 rgbft<1.000000,1.000000,1.000000,0.000000,0.000000> ]
				[ 0.700000 rgbft<1.000000,1.000000,1.000000,0.800000,0.000000> ]
				[ 0.900000 rgbft<1.000000,1.000000,1.000000,1.000000,0.000000> ]
				[ 1.000000 rgbft<1.000000,1.000000,1.000000,1.000000,0.000000> ]
			}
			translate <0.000000,0.000000,0.000000> 
			scale Mix_up * TF_scale 
			rotate <0.000000,0.000000,0.000000>
		}
		finish {
			F_Snow
		}
	}

// Rock covered by a lot of snow
#declare Rock_snow = 
	texture {
		Rock
	}

	texture {
		pigment {
			wrinkles
			color_map {
				[ 0.550000 rgbft<1.000000,1.000000,1.000000,0.000000,0.000000> ]
				[ 0.600000 rgbft<1.000000,1.000000,1.000000,0.800000,0.000000> ]
				[ 0.800000 rgbft<1.000000,1.000000,1.000000,1.000000,0.000000> ]
				[ 1.000000 rgbft<1.000000,1.000000,1.000000,1.000000,0.000000> ]
			}
			translate <0.000000,0.000000,0.000000> 
			scale Mix_up * TF_scale 
			rotate <0.000000,0.000000,0.000000>
		}
		finish {
			F_Snow
		}
	}

// Rock covered by some grass
#declare Rock_grass =
	texture {
		Rock
	}

	texture {
		pigment {
			wrinkles
			color_map {
				[ 0.550000 rgbft<0.080000,0.600000,0.250000,0.000000,0.000000> ]
				[ 0.600000 rgbft<0.008000,0.600000,0.250000,0.800000,0.000000> ]
				[ 0.850000 rgbft<0.080000,0.600000,0.250000,1.000000,0.000000> ]
				[ 1.000000 rgbft<0.078431,0.596078,0.247059,1.000000,0.000000> ]
			}
			translate <0.000000,0.000000,0.000000> 
			scale Mix_down * TF_scale 
			rotate <0.000000,0.000000,0.000000>
		}
		normal {
			N_Grass
		}
		finish {
			F_Grass
		}
	}

//---------------------------------------------
//  Main Texture
//---------------------------------------------

#local WL= TF_WATER_LEVEL;

#declare TF_LANDSCAPE_TEXTURE =
	texture {	
		gradient <0.000000,1.000000,0.000000>
		texture_map {
			[0  		pigment{ color< 0.0, 0.0, 0.0 > } ] //bottom of the lake
			[WL-WL*0.05	Rock ] //under water
			[WL		Rock_grass ] //water limit
			[WL		Rock_grass_snow ] //water limit
			[WL+(1-WL)*0.18	Rock_grass_snow2 ] //land
			[WL+(1-WL)*0.25 Rock_snow ] //rocks
			[WL+(1-WL)*0.35	Snow ] //mountains
		}
	}
