/*   FILE: queue.h -- 
 * AUTHOR: W. Michael Petullo <strmap@flyn.org>
 *   DATE: 08 January 2000
 *   NOTE: From _Mastering Algorithms with C_ by Kyle Loudon.
 */

#ifndef _QUEUE_H
#define _QUEUE_H

#ifdef __cplusplus
extern "C" {
#endif
#include <list.h>
/* ============================ queue_t ==================================== */
	typedef list_t queue_t;

/* ============================ queue_size ================================= */
#define queue_size list_size

/* ============================ queue_init () ============================== */
#define queue_init list_init

/* ============================ queue_destroy () =========================== */
#define queue_destroy list_destroy

/* ============================ queue_enqueue () =========================== */
    int queue_enqueue(queue_t * queue, const void *data);

/* ============================ queue_dequeue () =========================== */
    int queue_dequeue(queue_t * queue, void **data);

/* ============================ stack_peek () ============================== */
#define queue_peek(queue) ((queue)->head == NULL ? NULL : (queue)->head->data)

#ifdef __cplusplus
}
#endif
#endif				/* _QUEUE_H */
