from Synopsis.Config import Base

class Config(Base):
    class Formatter(Base.Formatter):
	"""Extend formatter config"""
	class DocBook:
	    """Create a config for a new module (most already have base
	    classes with default options)"""
	    name = 'DocBook'
	    def __init__(self, argv):
		pass

	class HTML_Synopsis (Base.Formatter.HTML):
	    """Create a formatter that makes HTML in Synopsis style. One is
	    already provided, but we must set the stylesheet"""
	    stylesheet_file = '../html.css'
	class HTML_Doxygen (Base.Formatter.HTML_Doxygen):
	    """Create a formatter that makes HTML in Doxygen style. Same as
	    about about the stylesheet - these are included with Synopsis."""
	    stylesheet_file = '../html-doxy.css'

	# Register the available config classes
	modules = {
	    'DocBook': DocBook,
	    'Synopsis': HTML_Synopsis,
	    'Doxygen': HTML_Doxygen
	}

    class Linker(Base.Linker):
	"""Extend linker config"""
	class CxxLinker(Base.Linker.Linker):
	    """Set the comment processing to recognise java-style comments,
	    and check for comments attached to previous declarations."""
	    comment_processors = ['java', 'prev', 'summary', 'javatags']
	
	# Register the new config class
	modules = {'Linker': CxxLinker}
    
