/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.internal.boot.PlatformURLHandler;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.osgi.framework.Bundle;

public class PlatformURLPluginConnection
extends PlatformURLConnection {
    private Bundle target = null;
    private static boolean isRegistered = false;
    private URL[] fragmentURLs = null;
    public static final String PLUGIN = "plugin";
    static /* synthetic */ Class class$0;

    public PlatformURLPluginConnection(URL url) {
        super(url);
    }

    protected boolean allowCaching() {
        return true;
    }

    protected URL resolve() throws IOException {
        String spec = this.url.getFile().trim();
        if (spec.startsWith("/")) {
            spec = spec.substring(1);
        }
        if (!spec.startsWith(PLUGIN)) {
            throw new IOException(Policy.bind("url.badVariant", this.url.toString()));
        }
        int ix = spec.indexOf("/", PLUGIN.length() + 1);
        String ref = ix == -1 ? spec.substring(PLUGIN.length() + 1) : spec.substring(PLUGIN.length() + 1, ix);
        String id = this.getId(ref);
        this.getVersion(ref);
        this.target = InternalPlatform.getDefault().getBundle(id);
        if (this.target == null) {
            throw new IOException(Policy.bind("url.resolvePlugin", this.url.toString()));
        }
        URL result = this.target.getEntry("");
        if (ix == -1 || ix + 1 >= spec.length()) {
            return result;
        }
        return new URL(result, spec.substring(ix + 1));
    }

    public static void startup() {
        if (isRegistered) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.internal.runtime.PlatformURLPluginConnection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformURLHandler.register(PLUGIN, clazz);
        isRegistered = true;
    }

    public URL[] getAuxillaryURLs() throws IOException {
        Bundle[] fragments;
        int fragmentLength;
        if (this.target == null) {
            String spec = this.url.getFile().trim();
            if (spec.startsWith("/")) {
                spec = spec.substring(1);
            }
            if (!spec.startsWith(PLUGIN)) {
                throw new IOException(Policy.bind("url.badVariant", this.url.toString()));
            }
            int ix = spec.indexOf("/", PLUGIN.length() + 1);
            String ref = ix == -1 ? spec.substring(PLUGIN.length() + 1) : spec.substring(PLUGIN.length() + 1, ix);
            String id = this.getId(ref);
            this.getVersion(ref);
            this.target = InternalPlatform.getDefault().getBundle(id);
            if (this.target == null) {
                throw new IOException(Policy.bind("url.resolvePlugin", this.url.toString()));
            }
        }
        int n = fragmentLength = (fragments = InternalPlatform.getDefault().getFragments(this.target)) == null ? 0 : fragments.length;
        if (fragmentLength == 0) {
            return null;
        }
        URL[] result = new URL[fragmentLength];
        int i = 0;
        while (i < fragmentLength) {
            result[i] = fragments[i].getEntry("");
            ++i;
        }
        return result;
    }
}

