/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.FontInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Combo
extends Composite {
    int menuHandle;
    public static final int LIMIT = Integer.MAX_VALUE;

    public Combo(Composite parent, int style) {
        super(parent, Combo.checkStyle(style));
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        char[] buffer = new char[string.length()];
        string.getChars(0, buffer.length, buffer, 0);
        int ptr = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)buffer.length);
        if (ptr == 0) {
            this.error(14);
        }
        int result = (this.style & 8) != 0 ? OS.AppendMenuItemTextWithCFString((int)this.menuHandle, (int)ptr, (int)0, (int)0, null) : OS.HIComboBoxAppendTextItem((int)this.handle, (int)ptr, null);
        OS.CFRelease((int)ptr);
        if (result != 0) {
            this.error(14);
        }
    }

    public void add(String string, int index) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int count = this.getItemCount();
        if (index < 0 || index > count) {
            this.error(6);
        }
        char[] buffer = new char[string.length()];
        string.getChars(0, buffer.length, buffer, 0);
        int ptr = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)buffer.length);
        if (ptr == 0) {
            this.error(14);
        }
        int result = (this.style & 8) != 0 ? OS.InsertMenuItemTextWithCFString((int)this.menuHandle, (int)ptr, (short)((short)index), (int)0, (int)0) : OS.HIComboBoxInsertTextItemAtIndex((int)this.handle, (int)index, (int)ptr);
        OS.CFRelease((int)ptr);
        if (result != 0) {
            this.error(14);
        }
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        style &= 0xFFFFF7FF;
        style &= 0xFFFFFCFF;
        if (((style = Widget.checkBits(style, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return style & 0xFFFFFFF7;
        }
        return style;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clearSelection() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            OS.SetControl32BitValue((int)this.handle, (int)0);
        } else {
            char[] buffer = new char[0];
            int ptr = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)buffer.length);
            if (ptr == 0) {
                return;
            }
            OS.SetControlData((int)this.handle, (int)5, (int)1667658612, (int)4, (int[])new int[]{ptr});
            OS.CFRelease((int)ptr);
        }
    }

    public org.eclipse.swt.graphics.Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        int[] currentPort = new int[1];
        short themeFont = (short)this.defaultThemeFont();
        if (this.font != null) {
            themeFont = 200;
            OS.GetPort((int[])currentPort);
            OS.SetPortWindowPort((int)OS.GetControlOwner((int)this.handle));
            OS.TextFont((short)this.font.id);
            OS.TextFace((short)this.font.style);
            OS.TextSize((short)this.font.size);
        }
        FontInfo info = new FontInfo();
        OS.GetFontInfo((FontInfo)info);
        height = info.ascent + info.descent;
        int[] ptr = new int[1];
        if ((this.style & 8) != 0) {
            int index = OS.GetControlValue((int)this.handle) - 1;
            OS.CopyMenuItemTextAsCFString((int)this.menuHandle, (short)((short)(index + 1)), (int[])ptr);
        } else {
            OS.GetControlData((int)this.handle, (short)5, (int)1667658612, (int)4, (int[])ptr, null);
        }
        Point ioBounds = new Point();
        if (ptr[0] != 0) {
            OS.GetThemeTextDimensions((int)ptr[0], (short)themeFont, (int)1, (boolean)false, (Point)ioBounds, null);
            width = Math.max(width, ioBounds.h);
            height = Math.max(height, ioBounds.v);
            OS.CFRelease((int)ptr[0]);
        }
        int count = (this.style & 8) != 0 ? OS.CountMenuItems((int)this.menuHandle) : OS.HIComboBoxGetItemCount((int)this.handle);
        int i = 0;
        while (i < count) {
            int result = (this.style & 8) != 0 ? OS.CopyMenuItemTextAsCFString((int)this.menuHandle, (short)((short)(i + 1)), (int[])ptr) : OS.HIComboBoxCopyTextItemAtIndex((int)this.handle, (int)i, (int[])ptr);
            if (result == 0) {
                OS.GetThemeTextDimensions((int)ptr[0], (short)themeFont, (int)1, (boolean)false, (Point)ioBounds, null);
                width = Math.max(width, ioBounds.h);
                OS.CFRelease((int)ptr[0]);
            }
            ++i;
        }
        if (this.font != null) {
            OS.SetPort((int)currentPort[0]);
        }
        int[] metric = new int[1];
        if ((this.style & 8) != 0) {
            OS.GetThemeMetric((int)22, (int[])metric);
            width += metric[0];
            width += 13;
        } else {
            OS.GetThemeMetric((int)74, (int[])metric);
            width += metric[0];
        }
        OS.GetThemeMetric((int)4, (int[])metric);
        width += metric[0] * 2;
        height += metric[0] * 2;
        Rect inset = this.getInset();
        width += inset.left + inset.right;
        height += inset.top + inset.bottom;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new org.eclipse.swt.graphics.Point(width, height);
    }

    public void copy() {
        short end;
        short start;
        this.checkWidget();
        int[] str = new int[1];
        if ((this.style & 8) != 0) {
            short index = OS.GetControlValue((int)this.handle);
            if (OS.CopyMenuItemTextAsCFString((int)this.menuHandle, (short)index, (int[])str) != 0) {
                return;
            }
            start = 0;
            end = (short)OS.CFStringGetLength((int)str[0]);
            if (start >= end) {
                OS.CFRelease((int)str[0]);
                return;
            }
        } else {
            short[] s = new short[2];
            OS.GetControlData((int)this.handle, (short)5, (int)1936026725, (int)4, (short[])s, null);
            if (s[0] >= s[1]) {
                return;
            }
            start = s[0];
            end = s[1];
            if (OS.GetControlData((int)this.handle, (short)5, (int)1667658612, (int)4, (int[])str, null) != 0) {
                return;
            }
        }
        CFRange range = new CFRange();
        range.location = start;
        range.length = end - start;
        int encoding = OS.CFStringGetSystemEncoding();
        int[] size = new int[1];
        OS.CFStringGetBytes((int)str[0], (CFRange)range, (int)encoding, (byte)63, (boolean)true, null, (int)0, (int[])size);
        byte[] buffer = new byte[size[0]];
        OS.CFStringGetBytes((int)str[0], (CFRange)range, (int)encoding, (byte)63, (boolean)true, (byte[])buffer, (int)size[0], (int[])size);
        OS.CFRelease((int)str[0]);
        OS.ClearCurrentScrap();
        int[] scrap = new int[1];
        OS.GetCurrentScrap((int[])scrap);
        OS.PutScrapFlavor((int)scrap[0], (int)0x54455854, (int)0, (int)buffer.length, (byte[])buffer);
    }

    void createHandle() {
        if ((this.style & 8) != 0) {
            int[] outControl = new int[1];
            int window = OS.GetControlOwner((int)this.parent.handle);
            OS.CreatePopupButtonControl((int)window, null, (int)0, (short)-12345, (boolean)false, (short)0, (short)0, (int)0, (int[])outControl);
            if (outControl[0] == 0) {
                this.error(2);
            }
            this.handle = outControl[0];
            int[] menuRef = new int[1];
            OS.CreateNewMenu((short)0, (int)0, (int[])menuRef);
            if (menuRef[0] == 0) {
                this.error(2);
            }
            this.menuHandle = menuRef[0];
            OS.SetControlPopupMenuHandle((int)this.handle, (int)this.menuHandle);
            OS.SetControl32BitMaximum((int)this.handle, (int)Short.MAX_VALUE);
        } else {
            int[] outControl = new int[1];
            CGRect rect = new CGRect();
            int inAttributes = 8;
            OS.HIComboBoxCreate((CGRect)rect, (int)0, null, (int)0, (int)inAttributes, (int[])outControl);
            if (outControl[0] == 0) {
                this.error(2);
            }
            this.handle = outControl[0];
            OS.SetControlData((int)this.handle, (int)5, (int)1684238964, (int)4, (byte[])new byte[1]);
            OS.SetControlVisibility((int)this.handle, (boolean)true, (boolean)false);
        }
    }

    public void cut() {
        short end;
        short start;
        this.checkWidget();
        int[] str = new int[1];
        if ((this.style & 8) != 0) {
            short index = OS.GetControlValue((int)this.handle);
            if (OS.CopyMenuItemTextAsCFString((int)this.menuHandle, (short)index, (int[])str) != 0) {
                return;
            }
            start = 0;
            end = (short)OS.CFStringGetLength((int)str[0]);
            if (start >= end) {
                OS.CFRelease((int)str[0]);
                return;
            }
        } else {
            short[] s = new short[2];
            OS.GetControlData((int)this.handle, (short)5, (int)1936026725, (int)4, (short[])s, null);
            if (s[0] >= s[1]) {
                return;
            }
            start = s[0];
            end = s[1];
            if (OS.GetControlData((int)this.handle, (short)5, (int)1667658612, (int)4, (int[])str, null) != 0) {
                return;
            }
        }
        CFRange range = new CFRange();
        range.location = start;
        range.length = end - start;
        int encoding = OS.CFStringGetSystemEncoding();
        int[] size = new int[1];
        OS.CFStringGetBytes((int)str[0], (CFRange)range, (int)encoding, (byte)63, (boolean)true, null, (int)0, (int[])size);
        byte[] buffer = new byte[size[0]];
        OS.CFStringGetBytes((int)str[0], (CFRange)range, (int)encoding, (byte)63, (boolean)true, (byte[])buffer, (int)size[0], (int[])size);
        OS.ClearCurrentScrap();
        int[] scrap = new int[1];
        OS.GetCurrentScrap((int[])scrap);
        OS.PutScrapFlavor((int)scrap[0], (int)0x54455854, (int)0, (int)buffer.length, (byte[])buffer);
        if ((this.style & 8) == 0) {
            range.location = 0;
            range.length = start;
            size = new int[1];
            OS.CFStringGetBytes((int)str[0], (CFRange)range, (int)encoding, (byte)63, (boolean)true, null, (int)0, (int[])size);
            byte[] preBuffer = new byte[size[0]];
            OS.CFStringGetBytes((int)str[0], (CFRange)range, (int)encoding, (byte)63, (boolean)true, (byte[])preBuffer, (int)size[0], (int[])size);
            range.location = end;
            range.length = OS.CFStringGetLength((int)str[0]) - end;
            size = new int[1];
            OS.CFStringGetBytes((int)str[0], (CFRange)range, (int)encoding, (byte)63, (boolean)true, null, (int)0, (int[])size);
            byte[] postBuffer = new byte[size[0]];
            OS.CFStringGetBytes((int)str[0], (CFRange)range, (int)encoding, (byte)63, (boolean)true, (byte[])postBuffer, (int)size[0], (int[])size);
            byte[] newBuffer = new byte[preBuffer.length + postBuffer.length];
            System.arraycopy(preBuffer, 0, newBuffer, 0, preBuffer.length);
            System.arraycopy(postBuffer, 0, newBuffer, preBuffer.length, postBuffer.length);
            int ptr = OS.CFStringCreateWithBytes((int)0, (byte[])newBuffer, (int)newBuffer.length, (int)encoding, (boolean)true);
            OS.SetControlData((int)this.handle, (int)5, (int)1667658612, (int)4, (int[])new int[]{ptr});
            OS.CFRelease((int)ptr);
            this.sendEvent(24);
        }
        OS.CFRelease((int)str[0]);
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index == -1) {
            return;
        }
    }

    public void deselectAll() {
        this.checkWidget();
    }

    public String getItem(int index) {
        this.checkWidget();
        int count = this.getItemCount();
        if (index < 0 || index >= count) {
            this.error(6);
        }
        int[] ptr = new int[1];
        int result = (this.style & 8) != 0 ? OS.CopyMenuItemTextAsCFString((int)this.menuHandle, (short)((short)(index + 1)), (int[])ptr) : OS.HIComboBoxCopyTextItemAtIndex((int)this.handle, (int)index, (int[])ptr);
        if (result != 0) {
            this.error(8);
        }
        int length = OS.CFStringGetLength((int)ptr[0]);
        char[] buffer = new char[length];
        CFRange range = new CFRange();
        range.length = length;
        OS.CFStringGetCharacters((int)ptr[0], (CFRange)range, (char[])buffer);
        OS.CFRelease((int)ptr[0]);
        return new String(buffer);
    }

    public int getItemCount() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return OS.CountMenuItems((int)this.menuHandle);
        }
        return OS.HIComboBoxGetItemCount((int)this.handle);
    }

    public int getItemHeight() {
        this.checkWidget();
        return 26;
    }

    public String[] getItems() {
        this.checkWidget();
        int count = this.getItemCount();
        String[] result = new String[count];
        int i = 0;
        while (i < count) {
            result[i] = this.getItem(i);
            ++i;
        }
        return result;
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public org.eclipse.swt.graphics.Point getSelection() {
        org.eclipse.swt.graphics.Point selection;
        this.checkWidget();
        if ((this.style & 8) != 0) {
            selection = new org.eclipse.swt.graphics.Point(0, 0);
        } else {
            short[] s = new short[2];
            OS.GetControlData((int)this.handle, (short)5, (int)1936026725, (int)4, (short[])s, null);
            selection = new org.eclipse.swt.graphics.Point(s[0], s[1]);
        }
        return selection;
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int index = (this.style & 8) != 0 ? OS.GetControlValue((int)this.handle) - 1 : this.indexOf(this.getText());
        return index;
    }

    public String getText() {
        int result;
        this.checkWidget();
        int[] ptr = new int[1];
        if ((this.style & 8) != 0) {
            int index = OS.GetControlValue((int)this.handle) - 1;
            result = OS.CopyMenuItemTextAsCFString((int)this.menuHandle, (short)((short)(index + 1)), (int[])ptr);
        } else {
            int[] actualSize = new int[1];
            result = OS.GetControlData((int)this.handle, (short)5, (int)1667658612, (int)4, (int[])ptr, (int[])actualSize);
        }
        if (result != 0) {
            return "";
        }
        int length = OS.CFStringGetLength((int)ptr[0]);
        char[] buffer = new char[length];
        CFRange range = new CFRange();
        range.length = length;
        OS.CFStringGetCharacters((int)ptr[0], (CFRange)range, (char[])buffer);
        OS.CFRelease((int)ptr[0]);
        return new String(buffer);
    }

    public int getTextHeight() {
        this.checkWidget();
        return 26;
    }

    public int getTextLimit() {
        this.checkWidget();
        return LIMIT;
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return this.getItemCount();
        }
        int[] buffer = new int[1];
        OS.GetControlData((int)this.handle, (short)0, (int)1667395177, (int)4, (int[])buffer, null);
        return buffer[0];
    }

    void hookEvents() {
        super.hookEvents();
        if ((this.style & 8) != 0) {
            int commandProc = this.display.commandProc;
            int[] mask = new int[]{1668113523, 1};
            int menuTarget = OS.GetMenuEventTarget((int)this.menuHandle);
            OS.InstallEventHandler((int)menuTarget, (int)commandProc, (int)(mask.length / 2), (int[])mask, (int)this.handle, null);
        }
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int count = this.getItemCount();
        if (start < 0 || start >= count) {
            return -1;
        }
        int i = start;
        while (i < count) {
            if (string.equals(this.getItem(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    Rect getInset() {
        return this.display.comboInset;
    }

    int kEventControlActivate(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlActivate(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        return 0;
    }

    int kEventProcessCommand(int nextHandler, int theEvent, int userData) {
        int result = super.kEventProcessCommand(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        this.postEvent(24);
        if (this.isDisposed()) {
            return -9874;
        }
        this.postEvent(13);
        return -9874;
    }

    int kEventRawKey(int nextHandler, int theEvent, int userData) {
        int[] keyCode = new int[1];
        OS.GetEventParameter((int)theEvent, (int)1801678692, (int)1835100014, null, (int)(keyCode.length * 4), null, (int[])keyCode);
        if (keyCode[0] == 36) {
            if (this.translateTraversal(keyCode[0], theEvent)) {
                return 0;
            }
            if (!this.sendKeyEvent(1, theEvent)) {
                return 0;
            }
            this.postEvent(14);
        }
        return -9874;
    }

    public void paste() {
        this.checkWidget();
        int[] scrap = new int[1];
        OS.GetCurrentScrap((int[])scrap);
        int[] size = new int[1];
        if (OS.GetScrapFlavorSize((int)scrap[0], (int)0x54455854, (int[])size) != 0 || size[0] == 0) {
            return;
        }
        byte[] buffer = new byte[size[0]];
        if (OS.GetScrapFlavorData((int)scrap[0], (int)0x54455854, (int[])size, (byte[])buffer) != 0) {
            return;
        }
        if ((this.style & 8) != 0) {
            String string = new String(buffer);
            int index = this.indexOf(string);
            if (index != -1) {
                this.select(index);
            }
        } else {
            byte[] newBuffer;
            int encoding = OS.CFStringGetSystemEncoding();
            int[] ptrOld = new int[1];
            if (OS.GetControlData((int)this.handle, (short)5, (int)1667658612, (int)4, (int[])ptrOld, null) == 0) {
                short[] s = new short[2];
                OS.GetControlData((int)this.handle, (short)5, (int)1936026725, (int)4, (short[])s, null);
                CFRange range = new CFRange();
                range.location = 0;
                range.length = s[0];
                size = new int[1];
                OS.CFStringGetBytes((int)ptrOld[0], (CFRange)range, (int)encoding, (byte)63, (boolean)true, null, (int)0, (int[])size);
                byte[] preBuffer = new byte[size[0]];
                OS.CFStringGetBytes((int)ptrOld[0], (CFRange)range, (int)encoding, (byte)63, (boolean)true, (byte[])preBuffer, (int)size[0], (int[])size);
                range.location = s[1];
                range.length = OS.CFStringGetLength((int)ptrOld[0]) - s[1];
                size = new int[1];
                OS.CFStringGetBytes((int)ptrOld[0], (CFRange)range, (int)encoding, (byte)63, (boolean)true, null, (int)0, (int[])size);
                byte[] postBuffer = new byte[size[0]];
                OS.CFStringGetBytes((int)ptrOld[0], (CFRange)range, (int)encoding, (byte)63, (boolean)true, (byte[])postBuffer, (int)size[0], (int[])size);
                newBuffer = new byte[preBuffer.length + buffer.length + postBuffer.length];
                System.arraycopy(preBuffer, 0, newBuffer, 0, preBuffer.length);
                System.arraycopy(buffer, 0, newBuffer, preBuffer.length, buffer.length);
                System.arraycopy(postBuffer, 0, newBuffer, preBuffer.length + buffer.length, postBuffer.length);
                OS.CFRelease((int)ptrOld[0]);
            } else {
                newBuffer = buffer;
            }
            int ptr = OS.CFStringCreateWithBytes((int)0, (byte[])newBuffer, (int)newBuffer.length, (int)encoding, (boolean)true);
            OS.SetControlData((int)this.handle, (int)5, (int)1667658612, (int)4, (int[])new int[]{ptr});
            OS.CFRelease((int)ptr);
            this.sendEvent(24);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.menuHandle != 0) {
            OS.DeleteMenu((short)OS.GetMenuID((int)this.menuHandle));
            OS.DisposeMenu((int)this.menuHandle);
        }
        this.menuHandle = 0;
    }

    public void remove(int index) {
        this.checkWidget();
        if (index == -1) {
            this.error(6);
        }
        int count = this.getItemCount();
        if (index < 0 || index >= count) {
            this.error(6);
        }
        if ((this.style & 8) != 0) {
            OS.DeleteMenuItems((int)this.menuHandle, (short)((short)(index + 1)), (int)1);
            if (index == OS.GetControlValue((int)this.handle) - 1) {
                OS.SetControl32BitValue((int)this.handle, (int)0);
            }
        } else {
            OS.HIComboBoxRemoveItemAtIndex((int)this.handle, (int)index);
        }
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        int count = this.getItemCount();
        if (start < 0 || start > end || end >= count) {
            this.error(6);
        }
        int newEnd = Math.min(end, count - 1);
        if ((this.style & 8) != 0) {
            OS.DeleteMenuItems((int)this.menuHandle, (short)((short)(start + 1)), (int)(newEnd - start + 1));
            int index = OS.GetControlValue((int)this.handle) - 1;
            if (start <= index && index <= end) {
                OS.SetControl32BitValue((int)this.handle, (int)0);
            }
        } else {
            int i = newEnd;
            while (i >= start) {
                OS.HIComboBoxRemoveItemAtIndex((int)this.handle, (int)i);
                --i;
            }
        }
    }

    public void remove(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int count = this.getItemCount();
        int i = 0;
        while (i < count) {
            String s = this.getItem(i);
            if (string.equals(s)) {
                this.remove(i);
                return;
            }
            ++i;
        }
        this.error(5);
    }

    public void removeAll() {
        this.checkWidget();
        int count = this.getItemCount();
        if ((this.style & 8) != 0) {
            OS.DeleteMenuItems((int)this.menuHandle, (short)1, (int)count);
            OS.SetControl32BitValue((int)this.handle, (int)0);
        } else if (count > 0) {
            int i = count - 1;
            while (i >= 0) {
                OS.HIComboBoxRemoveItemAtIndex((int)this.handle, (int)i);
                --i;
            }
        }
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void select(int index) {
        this.checkWidget();
        int count = this.getItemCount();
        if (index >= 0 && index < count) {
            if ((this.style & 8) != 0) {
                OS.SetControl32BitValue((int)this.handle, (int)(index + 1));
            } else {
                int[] ptr = new int[1];
                if (OS.HIComboBoxCopyTextItemAtIndex((int)this.handle, (int)index, (int[])ptr) != 0) {
                    return;
                }
                OS.SetControlData((int)this.handle, (int)5, (int)1667658612, (int)4, (int[])ptr);
                OS.CFRelease((int)ptr[0]);
            }
            this.sendEvent(24);
        }
    }

    boolean sendKeyEvent(int type, Event event) {
        if (!super.sendKeyEvent(type, event)) {
            return false;
        }
        if (type != 1) {
            return true;
        }
        if (event.character == '\u0000') {
            return true;
        }
        if ((this.style & 8) != 0) {
            return true;
        }
        this.postEvent(24);
        return true;
    }

    public void setItem(int index, String string) {
        int result;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int count = this.getItemCount();
        if (index < 0 || index >= count) {
            this.error(6);
        }
        char[] buffer = new char[string.length()];
        string.getChars(0, buffer.length, buffer, 0);
        int ptr = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)buffer.length);
        if (ptr == 0) {
            this.error(14);
        }
        if ((this.style & 8) != 0) {
            result = OS.SetMenuItemTextWithCFString((int)this.menuHandle, (short)((short)(index + 1)), (int)ptr);
        } else {
            result = OS.HIComboBoxInsertTextItemAtIndex((int)this.handle, (int)index, (int)ptr);
            OS.HIComboBoxRemoveItemAtIndex((int)this.handle, (int)(index + 1));
        }
        OS.CFRelease((int)ptr);
        if (result != 0) {
            this.error(14);
        }
    }

    public void setItems(String[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        this.removeAll();
        if (items.length == 0) {
            return;
        }
        int i = 0;
        while (i < items.length) {
            String string = items[i];
            if (string != null) {
                int result;
                char[] buffer = new char[string.length()];
                string.getChars(0, buffer.length, buffer, 0);
                int ptr = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)buffer.length);
                if (ptr == 0) {
                    this.error(14);
                }
                if ((this.style & 8) != 0) {
                    result = OS.AppendMenuItemTextWithCFString((int)this.menuHandle, (int)ptr, (int)0, (int)0, null);
                } else {
                    int[] outIndex = new int[1];
                    result = OS.HIComboBoxAppendTextItem((int)this.handle, (int)ptr, (int[])outIndex);
                }
                OS.CFRelease((int)ptr);
                if (result != 0) {
                    this.error(14);
                }
            }
            ++i;
        }
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
    }

    public void setSelection(org.eclipse.swt.graphics.Point selection) {
        this.checkWidget();
        if (selection == null) {
            this.error(4);
        }
        if ((this.style & 8) == 0) {
            short[] s = new short[]{(short)selection.x, (short)selection.y};
            OS.SetControlData((int)this.handle, (int)5, (int)1936026725, (int)4, (short[])s);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            int index = this.indexOf(string);
            if (index != -1) {
                this.select(index);
            }
        } else {
            char[] buffer = new char[string.length()];
            string.getChars(0, buffer.length, buffer, 0);
            int ptr = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)buffer.length);
            if (ptr == 0) {
                return;
            }
            OS.SetControlData((int)this.handle, (int)5, (int)1667658612, (int)4, (int[])new int[]{ptr});
            OS.CFRelease((int)ptr);
            this.sendEvent(24);
        }
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
    }

    public void setVisibleItemCount(int count) {
        this.checkWidget();
        if (count < 0) {
            return;
        }
        if ((this.style & 8) == 0) {
            OS.SetControlData((int)this.handle, (int)0, (int)1667395177, (int)4, (int[])new int[]{count});
        }
    }
}

