/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.OS;

public final class Font {
    public int handle;
    Device device;

    Font() {
    }

    public Font(Device device, FontData fd) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, fd);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Font(Device device, FontData[] fds) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (fds == null) {
            SWT.error(4);
        }
        if (fds.length == 0) {
            SWT.error(5);
        }
        this.init(device, fds[0]);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Font(Device device, String name, int height, int style) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (name == null) {
            SWT.error(4);
        }
        this.init(device, new FontData(name, height, style));
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        OS.DeleteObject(this.handle);
        this.handle = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Font)) {
            return false;
        }
        Font font = (Font)object;
        return this.device == font.device && this.handle == font.handle;
    }

    public FontData[] getFontData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        LOGFONT logFont = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
        OS.GetObject(this.handle, LOGFONT.sizeof, logFont);
        return new FontData[]{FontData.win32_new(logFont, this.device.computePoints(logFont))};
    }

    public int hashCode() {
        return this.handle;
    }

    void init(Device device, FontData fd) {
        if (fd == null) {
            SWT.error(4);
        }
        this.device = device;
        LOGFONT logFont = fd.data;
        int lfHeight = logFont.lfHeight;
        logFont.lfHeight = device.computePixels(fd.height);
        this.handle = OS.CreateFontIndirect(logFont);
        logFont.lfHeight = lfHeight;
        if (this.handle == 0) {
            SWT.error(2);
        }
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Font {*DISPOSED*}";
        }
        return "Font {" + this.handle + "}";
    }

    public static Font win32_new(Device device, int handle) {
        if (device == null) {
            device = Device.getDevice();
        }
        Font font = new Font();
        font.handle = handle;
        font.device = device;
        return font;
    }
}

