/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.AbstractHandler;
import org.eclipse.ui.commands.ExecutionException;
import org.eclipse.ui.commands.HandlerSubmission;
import org.eclipse.ui.internal.ColorSchemeService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.presentations.BasicStackPresentation;
import org.eclipse.ui.internal.presentations.EditorList;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.themes.ITheme;

public class EditorPresentation
extends BasicStackPresentation {
    private IPreferenceStore preferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
    private HandlerSubmission openEditorDropDownHandlerSubmission;
    private CTabFolder2Adapter showListListener = new CTabFolder2Adapter(){

        public void showList(CTabFolderEvent event) {
            CTabFolder tabFolder = EditorPresentation.this.getTabFolder();
            event.doit = false;
            Point p = tabFolder.toDisplay(event.x, event.y);
            p.y += event.height;
            EditorPresentation.this.showList(tabFolder.getShell(), p.x, p.y);
        }
    };
    private final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("EDITOR_TAB_POSITION".equals(propertyChangeEvent.getProperty()) && !EditorPresentation.this.isDisposed()) {
                int tabLocation = EditorPresentation.this.preferenceStore.getInt("EDITOR_TAB_POSITION");
                EditorPresentation.this.setTabPosition(tabLocation);
            } else if ("SHOW_TRADITIONAL_STYLE_TABS".equals(propertyChangeEvent.getProperty()) && !EditorPresentation.this.isDisposed()) {
                boolean traditionalTab = EditorPresentation.this.preferenceStore.getBoolean("SHOW_TRADITIONAL_STYLE_TABS");
                EditorPresentation.this.setTabStyle(traditionalTab);
            }
            boolean multiChanged = "SHOW_MULTIPLE_EDITOR_TABS".equals(propertyChangeEvent.getProperty());
            boolean styleChanged = "SHOW_TRADITIONAL_STYLE_TABS".equals(propertyChangeEvent.getProperty());
            CTabFolder tabFolder = EditorPresentation.this.getTabFolder();
            if ((multiChanged || styleChanged) && tabFolder != null) {
                if (multiChanged) {
                    boolean multi = EditorPresentation.this.preferenceStore.getBoolean("SHOW_MULTIPLE_EDITOR_TABS");
                    tabFolder.setSingleTab(!multi);
                } else {
                    boolean simple = EditorPresentation.this.preferenceStore.getBoolean("SHOW_TRADITIONAL_STYLE_TABS");
                    tabFolder.setSimpleTab(simple);
                }
                CTabItem[] tabItems = tabFolder.getItems();
                int i = 0;
                while (i < tabItems.length) {
                    CTabItem tabItem = tabItems[i];
                    EditorPresentation.this.initTab(tabItem, EditorPresentation.this.getPartForTab(tabItem));
                    ++i;
                }
            }
        }
    };

    public EditorPresentation(Composite parent, IStackPresentationSite newSite, int flags) {
        super(new CTabFolder(parent, 2048), newSite);
        final CTabFolder tabFolder = this.getTabFolder();
        tabFolder.addCTabFolder2Listener((CTabFolder2Listener)this.showListListener);
        this.preferenceStore.addPropertyChangeListener(this.propertyChangeListener);
        int tabLocation = this.preferenceStore.getInt("EDITOR_TAB_POSITION");
        this.setTabPosition(tabLocation);
        tabFolder.setSingleTab(!this.preferenceStore.getBoolean("SHOW_MULTIPLE_EDITOR_TABS"));
        this.setTabStyle(this.preferenceStore.getBoolean("SHOW_TRADITIONAL_STYLE_TABS"));
        tabFolder.setUnselectedCloseVisible(true);
        tabFolder.setUnselectedImageVisible(true);
        ColorSchemeService.setTabAttributes(this, tabFolder);
        this.updateGradient();
        tabFolder.setMinimizeVisible((flags & 0x80) != 0);
        tabFolder.setMaximizeVisible((flags & 0x400) != 0);
        final Shell shell = tabFolder.getShell();
        AbstractHandler openEditorDropDownHandler = new AbstractHandler(){

            public void execute(Object parameter) throws ExecutionException {
                Rectangle clientArea = tabFolder.getClientArea();
                Point location = tabFolder.getDisplay().map((Control)tabFolder, null, clientArea.x, clientArea.y);
                EditorPresentation.this.showList(shell, location.x, location.y);
            }
        };
        this.openEditorDropDownHandlerSubmission = new HandlerSubmission(null, "org.eclipse.ui.window.openEditorDropDown", openEditorDropDownHandler, 1, shell);
        PlatformUI.getWorkbench().getCommandSupport().addHandlerSubmissions(Collections.singletonList(this.openEditorDropDownHandlerSubmission));
    }

    public void dispose() {
        if (this.openEditorDropDownHandlerSubmission != null) {
            PlatformUI.getWorkbench().getCommandSupport().removeHandlerSubmissions(Collections.singletonList(this.openEditorDropDownHandlerSubmission));
            this.openEditorDropDownHandlerSubmission = null;
        }
        this.preferenceStore.removePropertyChangeListener(this.propertyChangeListener);
        this.getTabFolder().removeCTabFolder2Listener((CTabFolder2Listener)this.showListListener);
        super.dispose();
    }

    protected void initTab(CTabItem tabItem, IPresentablePart part) {
        tabItem.setText(this.getLabelText(part, true, (this.getTabFolder().getStyle() & 2) == 0));
        tabItem.setImage(this.getLabelImage(part));
        tabItem.setToolTipText(this.getLabelToolTipText(part));
    }

    String getLabelText(IPresentablePart presentablePart, boolean dirtyLeft, boolean includePath) {
        String title;
        String text = title = presentablePart.getTitle().trim();
        if (includePath) {
            String titleTooltip = presentablePart.getTitleToolTip().trim();
            if (titleTooltip.endsWith(title)) {
                titleTooltip = titleTooltip.substring(0, titleTooltip.lastIndexOf(title)).trim();
            }
            if (titleTooltip.endsWith("\\")) {
                titleTooltip = titleTooltip.substring(0, titleTooltip.lastIndexOf("\\")).trim();
            }
            if (titleTooltip.endsWith("/")) {
                titleTooltip = titleTooltip.substring(0, titleTooltip.lastIndexOf("/")).trim();
            }
            if (titleTooltip.length() >= 1) {
                text = String.valueOf(text) + " - " + titleTooltip;
            }
        }
        if (presentablePart.isDirty()) {
            text = dirtyLeft ? "* " + text : String.valueOf(text) + " *";
        }
        return text;
    }

    Image getLabelImage(IPresentablePart presentablePart) {
        return presentablePart.getTitleImage();
    }

    String getLabelToolTipText(IPresentablePart presentablePart) {
        return presentablePart.getTitleToolTip();
    }

    public void setActive(boolean isActive) {
        super.setActive(isActive);
        this.updateGradient();
    }

    protected void setTabStyle(boolean traditionalTab) {
        this.getTabFolder().setSimpleTab(traditionalTab);
    }

    private void showList(Shell parentShell, int x, int y) {
        CTabFolder tabFolder = this.getTabFolder();
        ArrayList<CTabItem> items = new ArrayList<CTabItem>(Arrays.asList(tabFolder.getItems()));
        Iterator<CTabItem> iterator = items.iterator();
        while (iterator.hasNext()) {
            CTabItem tabItem = iterator.next();
            if (!tabItem.isShowing()) continue;
            iterator.remove();
        }
        if (items.isEmpty()) {
            return;
        }
        int shellStyle = 16408;
        int tableStyle = 768;
        final EditorList editorList = new EditorList(tabFolder.getShell(), shellStyle, tableStyle);
        editorList.setInput(this);
        Point size = editorList.computeSizeHint();
        int minX = 50;
        int minY = 300;
        if (size.x < minX) {
            size.x = minX;
        }
        if (size.y < minY) {
            size.y = minY;
        }
        editorList.setSize(size.x, size.y);
        Rectangle bounds = Display.getCurrent().getBounds();
        if (x + size.x > bounds.width) {
            x = bounds.width - size.x;
        }
        if (y + size.y > bounds.height) {
            y = bounds.height - size.y;
        }
        editorList.setLocation(new Point(x, y));
        editorList.setVisible(true);
        editorList.setFocus();
        editorList.getTableViewer().getTable().getShell().addListener(27, new Listener(){

            public void handleEvent(Event event) {
                editorList.setVisible(false);
            }
        });
    }

    private void updateGradient() {
        boolean vertical;
        Color fgColor;
        ITheme currentTheme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        FontRegistry fontRegistry = currentTheme.getFontRegistry();
        ColorRegistry colorRegistry = currentTheme.getColorRegistry();
        Color[] bgColors = new Color[2];
        int[] percent = new int[1];
        if (this.isActive()) {
            fgColor = colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR");
            bgColors[0] = colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START");
            bgColors[1] = colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END");
            percent[0] = currentTheme.getInt("org.eclipse.ui.workbench.ACTIVE_TAB_PERCENT");
            vertical = currentTheme.getBoolean("org.eclipse.ui.workbench.ACTIVE_TAB_VERTICAL");
        } else {
            fgColor = colorRegistry.get("org.eclipse.ui.workbench.INACTIVE_TAB_TEXT_COLOR");
            bgColors[0] = colorRegistry.get("org.eclipse.ui.workbench.INACTIVE_TAB_BG_START");
            bgColors[1] = colorRegistry.get("org.eclipse.ui.workbench.INACTIVE_TAB_BG_END");
            percent[0] = currentTheme.getInt("org.eclipse.ui.workbench.INACTIVE_TAB_PERCENT");
            vertical = currentTheme.getBoolean("org.eclipse.ui.workbench.INACTIVE_TAB_VERTICAL");
        }
        this.getTabFolder().setFont(fontRegistry.get("org.eclipse.ui.workbench.TAB_TEXT_FONT"));
        this.drawGradient(fgColor, bgColors, percent, vertical);
    }

    void setSelection(CTabItem tabItem) {
        this.getSite().selectPart(this.getPartForTab(tabItem));
    }

    void close(IPresentablePart presentablePart) {
        this.getSite().close(presentablePart);
    }

    protected String getCurrentTitle() {
        return "";
    }
}

