/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.ui.internal.commands.KeySequenceBindingDefinition;
import org.eclipse.ui.internal.commands.KeySequenceBindingNode;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.keys.KeySequence;

final class KeySequenceBindingMachine {
    private String[] activeContextIds = new String[0];
    private String[] activeKeyConfigurationIds = new String[0];
    private String[] activeLocales = new String[0];
    private String[] activePlatforms = new String[0];
    private List[] keySequenceBindings = new List[]{new ArrayList(), new ArrayList()};
    private Map keySequenceBindingsByCommandId;
    private Map matchesByKeySequence;
    private boolean solved;
    private SortedMap tree;
    static /* synthetic */ Class class$0;

    KeySequenceBindingMachine() {
    }

    String[] getActiveContextIds() {
        return (String[])this.activeContextIds.clone();
    }

    String[] getActiveKeyConfigurationIds() {
        return (String[])this.activeKeyConfigurationIds.clone();
    }

    String[] getActiveLocales() {
        return (String[])this.activeLocales.clone();
    }

    String[] getActivePlatforms() {
        return (String[])this.activePlatforms.clone();
    }

    List getKeySequenceBindings0() {
        return this.keySequenceBindings[0];
    }

    List getKeySequenceBindings1() {
        return this.keySequenceBindings[1];
    }

    Map getKeySequenceBindingsByCommandId() {
        if (this.keySequenceBindingsByCommandId == null) {
            this.validateSolution();
            this.keySequenceBindingsByCommandId = Collections.unmodifiableMap(KeySequenceBindingNode.getKeySequenceBindingsByCommandId(this.getMatchesByKeySequence()));
        }
        return this.keySequenceBindingsByCommandId;
    }

    Map getMatchesByKeySequence() {
        if (this.matchesByKeySequence == null) {
            this.validateSolution();
            this.matchesByKeySequence = KeySequenceBindingNode.getMatchesByKeySequence(this.tree, KeySequence.getInstance());
        }
        return this.matchesByKeySequence;
    }

    private void invalidateSolution() {
        this.solved = false;
        this.keySequenceBindingsByCommandId = null;
        this.matchesByKeySequence = null;
    }

    private void invalidateTree() {
        this.tree = null;
        this.invalidateSolution();
    }

    boolean setActiveContextIds(String[] activeContextIds) {
        if (activeContextIds == null) {
            throw new NullPointerException();
        }
        if (!Arrays.equals(this.activeContextIds, activeContextIds = (String[])activeContextIds.clone())) {
            this.activeContextIds = activeContextIds;
            this.invalidateSolution();
            return true;
        }
        return false;
    }

    boolean setActiveKeyConfigurationIds(String[] activeKeyConfigurationIds) {
        if (activeKeyConfigurationIds == null) {
            throw new NullPointerException();
        }
        if (!Arrays.equals(this.activeKeyConfigurationIds, activeKeyConfigurationIds = (String[])activeKeyConfigurationIds.clone())) {
            this.activeKeyConfigurationIds = activeKeyConfigurationIds;
            this.invalidateSolution();
            return true;
        }
        return false;
    }

    boolean setActiveLocales(String[] activeLocales) {
        if (activeLocales == null) {
            throw new NullPointerException();
        }
        if (!Arrays.equals(this.activeLocales, activeLocales = (String[])activeLocales.clone())) {
            this.activeLocales = activeLocales;
            this.invalidateSolution();
            return true;
        }
        return false;
    }

    boolean setActivePlatforms(String[] activePlatforms) {
        if (activePlatforms == null) {
            throw new NullPointerException();
        }
        if (!Arrays.equals(this.activePlatforms, activePlatforms = (String[])activePlatforms.clone())) {
            this.activePlatforms = activePlatforms;
            this.invalidateSolution();
            return true;
        }
        return false;
    }

    boolean setKeySequenceBindings0(List keySequenceBindings0) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.commands.KeySequenceBindingDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!this.keySequenceBindings[0].equals(keySequenceBindings0 = Util.safeCopy(keySequenceBindings0, (Class)clazz))) {
            this.keySequenceBindings[0] = keySequenceBindings0;
            this.invalidateTree();
            return true;
        }
        return false;
    }

    boolean setKeySequenceBindings1(List keySequenceBindings1) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.commands.KeySequenceBindingDefinition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!this.keySequenceBindings[1].equals(keySequenceBindings1 = Util.safeCopy(keySequenceBindings1, (Class)clazz))) {
            this.keySequenceBindings[1] = keySequenceBindings1;
            this.invalidateTree();
            return true;
        }
        return false;
    }

    private void validateSolution() {
        if (!this.solved) {
            this.validateTree();
            KeySequenceBindingNode.solve(this.tree, this.activeContextIds, this.activeKeyConfigurationIds, this.activePlatforms, this.activeLocales);
            this.solved = true;
        }
    }

    private void validateTree() {
        if (this.tree == null) {
            this.tree = new TreeMap();
            int i = 0;
            while (i < this.keySequenceBindings.length) {
                Iterator iterator = this.keySequenceBindings[i].iterator();
                while (iterator.hasNext()) {
                    KeySequenceBindingDefinition keySequenceBindingDefinition = (KeySequenceBindingDefinition)iterator.next();
                    KeySequenceBindingNode.add(this.tree, keySequenceBindingDefinition.getKeySequence(), keySequenceBindingDefinition.getContextId(), keySequenceBindingDefinition.getKeyConfigurationId(), i, keySequenceBindingDefinition.getPlatform(), keySequenceBindingDefinition.getLocale(), keySequenceBindingDefinition.getCommandId());
                }
                ++i;
            }
        }
    }
}

