/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.TrimLayoutData;

public class TrimLayout
extends Layout {
    private static final TrimLayoutData defaultData = new TrimLayoutData();
    private Control centerArea;
    private List[] controls;
    private int[] trimSizes;
    private int marginWidth;
    private int marginHeight;
    private int topSpacing;
    private int bottomSpacing;
    private int leftSpacing;
    private int rightSpacing;
    private Map mapPartOntoPosition = new HashMap();
    private static final int TOP = 0;
    private static final int BOTTOM = 1;
    private static final int LEFT = 2;
    private static final int RIGHT = 3;
    private static final int NONTRIM = 4;

    public TrimLayout() {
        this.controls = new List[4];
        this.trimSizes = new int[this.controls.length];
        int idx = 0;
        while (idx < this.controls.length) {
            this.controls[idx] = new LinkedList();
            this.trimSizes[idx] = -1;
            ++idx;
        }
    }

    public void setSpacing(int left, int right, int top, int bottom) {
        this.leftSpacing = left;
        this.rightSpacing = right;
        this.topSpacing = top;
        this.bottomSpacing = bottom;
    }

    public void setMargins(int marginWidth, int marginHeight) {
        this.marginWidth = marginWidth;
        this.marginHeight = marginHeight;
    }

    private int convertSwtConstantToIndex(int positionConstant) {
        switch (positionConstant) {
            case 128: {
                return 0;
            }
            case 1024: {
                return 1;
            }
            case 16384: {
                return 2;
            }
            case 131072: {
                return 3;
            }
        }
        return 0;
    }

    private int convertIndexToSwtConstant(int index) {
        switch (index) {
            case 0: {
                return 128;
            }
            case 1: {
                return 1024;
            }
            case 2: {
                return 16384;
            }
            case 3: {
                return 131072;
            }
            case 4: {
                return -1;
            }
        }
        return 0;
    }

    private int getFixedSize(List controls, int hint, boolean width) {
        int sum = 0;
        Iterator iter = controls.iterator();
        while (iter.hasNext()) {
            Control next = (Control)iter.next();
            TrimLayout.getData(next);
            sum += TrimLayout.getSize(next, hint, width);
        }
        return sum;
    }

    private static void filterResizable(List input, List resizable, List nonResizable, boolean width) {
        Iterator iter = input.iterator();
        while (iter.hasNext()) {
            Control next = (Control)iter.next();
            if (TrimLayout.isResizable(next, width)) {
                resizable.add(next);
                continue;
            }
            nonResizable.add(next);
        }
    }

    private static boolean isResizable(Control control, boolean horizontally) {
        TrimLayoutData data = TrimLayout.getData(control);
        if (!data.resizable) {
            return false;
        }
        if (horizontally) {
            return data.widthHint == -1;
        }
        return data.heightHint == -1;
    }

    private static TrimLayoutData getData(Control control) {
        TrimLayoutData data = (TrimLayoutData)control.getLayoutData();
        if (data == null) {
            data = defaultData;
        }
        return data;
    }

    private static Point computeSize(Control toCompute, int widthHint, int heightHint) {
        TrimLayoutData data = TrimLayout.getData(toCompute);
        if (widthHint == -1) {
            widthHint = data.widthHint;
        }
        if (heightHint == -1) {
            heightHint = data.heightHint;
        }
        if (widthHint == -1 || heightHint == -1) {
            return toCompute.computeSize(widthHint, heightHint);
        }
        return new Point(widthHint, heightHint);
    }

    private static int getSize(Control toCompute, int hint, boolean width) {
        if (width) {
            return TrimLayout.computeSize((Control)toCompute, (int)-1, (int)hint).x;
        }
        return TrimLayout.computeSize((Control)toCompute, (int)hint, (int)-1).y;
    }

    private static int maxDimension(List controls, int hint, boolean width) {
        if (hint == -1) {
            int result = 0;
            Iterator iter = controls.iterator();
            while (iter.hasNext()) {
                Control next = (Control)iter.next();
                result = Math.max(TrimLayout.getSize(next, -1, width), result);
            }
            return result;
        }
        ArrayList resizable = new ArrayList(controls.size());
        ArrayList nonResizable = new ArrayList(controls.size());
        TrimLayout.filterResizable(controls, resizable, nonResizable, width);
        int result = 0;
        int usedHeight = 0;
        Iterator iter = nonResizable.iterator();
        while (iter.hasNext()) {
            Control next = (Control)iter.next();
            Point nextSize = TrimLayout.computeSize(next, -1, -1);
            if (width) {
                result = Math.max(result, nextSize.x);
                usedHeight += nextSize.y;
                continue;
            }
            result = Math.max(result, nextSize.y);
            usedHeight += nextSize.x;
        }
        if (resizable.size() > 0) {
            int individualHint = (hint - usedHeight) / resizable.size();
            iter = resizable.iterator();
            while (iter.hasNext()) {
                Control next = (Control)iter.next();
                result = Math.max(result, TrimLayout.getSize(next, individualHint, width));
            }
        }
        return result;
    }

    public void setTrimSize(int position, int size) {
        int idx = this.convertSwtConstantToIndex(position);
        this.trimSizes[idx] = size;
    }

    public int getTrimLocation(Control trimControl) {
        return this.convertIndexToSwtConstant(this.getIndex(trimControl));
    }

    public void addTrim(Control control, int location) {
        this.addTrim(control, location, null);
    }

    public void addTrim(Control control, int location, Control position) {
        this.removeTrim(control);
        int index = this.convertSwtConstantToIndex(location);
        List list = this.controls[index];
        TrimLayout.insertBefore(list, control, position);
        this.mapPartOntoPosition.put(control, new Integer(index));
    }

    private static void insertBefore(List list, Object toInsert, Object position) {
        int insertIndex = -1;
        if (position != null) {
            insertIndex = list.indexOf(position);
        }
        if (insertIndex != -1) {
            list.add(insertIndex, toInsert);
        } else {
            list.add(toInsert);
        }
    }

    public void removeTrim(Control toRemove) {
        int idx = this.getIndex(toRemove);
        if (idx == 4) {
            return;
        }
        this.controls[idx].remove(toRemove);
        this.mapPartOntoPosition.remove(toRemove);
    }

    private int getIndex(Control toQuery) {
        Integer position = (Integer)this.mapPartOntoPosition.get(toQuery);
        if (position == null) {
            return 4;
        }
        return position;
    }

    private void removeDisposed() {
        int idx = 0;
        while (idx < this.controls.length) {
            List ctrl = this.controls[idx];
            if (ctrl != null) {
                Iterator iter = ctrl.iterator();
                while (iter.hasNext()) {
                    Control next = (Control)iter.next();
                    if (!next.isDisposed() && this.getIndex(next) == idx) continue;
                    iter.remove();
                }
            }
            ++idx;
        }
    }

    private int[] getTrimSizes(int widthHint, int heightHint) {
        int[] trimSize = new int[this.controls.length];
        int idx = 0;
        while (idx < this.trimSizes.length) {
            trimSize[idx] = this.controls[idx].isEmpty() ? 0 : this.trimSizes[idx];
            ++idx;
        }
        if (trimSize[0] == -1) {
            trimSize[0] = TrimLayout.maxDimension(this.controls[0], widthHint, false);
        }
        if (trimSize[1] == -1) {
            trimSize[1] = TrimLayout.maxDimension(this.controls[1], widthHint, false);
        }
        if (trimSize[2] == -1) {
            trimSize[2] = TrimLayout.maxDimension(this.controls[2], heightHint, true);
        }
        if (trimSize[3] == -1) {
            trimSize[3] = TrimLayout.maxDimension(this.controls[3], heightHint, true);
        }
        return trimSize;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Point result = new Point(wHint, hHint);
        int[] trimSize = this.getTrimSizes(wHint, hHint);
        int horizontalTrim = trimSize[2] + trimSize[3] + 2 * this.marginWidth + this.leftSpacing + this.rightSpacing;
        int verticalTrim = trimSize[0] + trimSize[1] + 2 * this.marginHeight + this.topSpacing + this.bottomSpacing;
        Point innerSize = this.centerArea == null ? new Point(0, 0) : this.centerArea.computeSize(wHint == -1 ? wHint : wHint - horizontalTrim, hHint == -1 ? hHint : hHint - verticalTrim);
        if (wHint == -1) {
            result.x = innerSize.x + horizontalTrim;
        } else if (hHint == -1) {
            result.y = innerSize.y + verticalTrim;
        }
        return new Point(0, 0);
    }

    protected void layout(Composite composite, boolean flushCache) {
        this.removeDisposed();
        Rectangle clientArea = composite.getClientArea();
        clientArea.x += this.marginWidth;
        clientArea.width -= 2 * this.marginWidth;
        clientArea.y += this.marginHeight;
        clientArea.height -= 2 * this.marginHeight;
        int[] trimSize = this.getTrimSizes(clientArea.width, clientArea.height);
        int leftOfLayout = clientArea.x;
        int leftOfCenterPane = leftOfLayout + trimSize[2] + this.leftSpacing;
        int widthOfCenterPane = clientArea.width - trimSize[2] - trimSize[3] - this.leftSpacing - this.rightSpacing;
        int rightOfCenterPane = clientArea.x + clientArea.width - trimSize[3];
        int topOfLayout = clientArea.y;
        int topOfCenterPane = topOfLayout + trimSize[0] + this.topSpacing;
        int heightOfCenterPane = clientArea.height - trimSize[0] - trimSize[1] - this.topSpacing - this.bottomSpacing;
        int bottomOfCenterPane = clientArea.y + clientArea.height - trimSize[1];
        TrimLayout.arrange(new Rectangle(leftOfLayout, topOfLayout, clientArea.width, trimSize[0]), this.controls[0], true);
        TrimLayout.arrange(new Rectangle(leftOfCenterPane, bottomOfCenterPane, widthOfCenterPane, trimSize[1]), this.controls[1], true);
        TrimLayout.arrange(new Rectangle(leftOfLayout, topOfCenterPane, trimSize[2], clientArea.height - trimSize[0]), this.controls[2], false);
        TrimLayout.arrange(new Rectangle(rightOfCenterPane, topOfCenterPane, trimSize[3], clientArea.height - trimSize[0]), this.controls[3], false);
        if (this.centerArea != null) {
            this.centerArea.setBounds(leftOfCenterPane, topOfCenterPane, widthOfCenterPane, heightOfCenterPane);
        }
    }

    private static void arrange(Rectangle area, List controls, boolean horizontally) {
        Point currentPosition = new Point(area.x, area.y);
        ArrayList resizable = new ArrayList(controls.size());
        ArrayList nonResizable = new ArrayList(controls.size());
        TrimLayout.filterResizable(controls, resizable, nonResizable, horizontally);
        int[] sizes = new int[nonResizable.size()];
        int idx = 0;
        int used = 0;
        int hint = Geometry.getDimension((Rectangle)area, (!horizontally ? 1 : 0) != 0);
        Iterator iter = nonResizable.iterator();
        while (iter.hasNext()) {
            Control next = (Control)iter.next();
            sizes[idx] = TrimLayout.getSize(next, hint, horizontally);
            used += sizes[idx];
            ++idx;
        }
        int available = Geometry.getDimension((Rectangle)area, (boolean)horizontally) - used;
        idx = 0;
        int remainingResizable = resizable.size();
        iter = controls.iterator();
        while (iter.hasNext()) {
            int thisSize;
            Control next = (Control)iter.next();
            if (TrimLayout.isResizable(next, horizontally)) {
                thisSize = available / remainingResizable;
                available -= thisSize;
                --remainingResizable;
            } else {
                thisSize = sizes[idx];
                ++idx;
            }
            if (horizontally) {
                next.setBounds(currentPosition.x, currentPosition.y, thisSize, hint);
                currentPosition.x += thisSize;
                continue;
            }
            next.setBounds(currentPosition.x, currentPosition.y, hint, thisSize);
            currentPosition.y += thisSize;
        }
    }

    public void setCenterControl(Control center) {
        this.centerArea = center;
    }

    public Control getCenterControl() {
        return this.centerArea;
    }
}

