/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.presentations.IPartMenu;
import org.eclipse.ui.presentations.IPresentablePart;

public class PresentableEditorPart
implements IPresentablePart {
    private final List listeners = new ArrayList();
    private EditorPane pane;
    private final IPropertyListener propertyListenerProxy = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            int i = 0;
            while (i < PresentableEditorPart.this.listeners.size()) {
                ((IPropertyListener)PresentableEditorPart.this.listeners.get(i)).propertyChanged(PresentableEditorPart.this, propId);
                ++i;
            }
        }
    };

    public PresentableEditorPart(EditorPane pane) {
        this.pane = pane;
    }

    public void addPropertyListener(IPropertyListener listener) {
        if (this.listeners.isEmpty()) {
            this.getEditorReference().addPropertyListener(this.propertyListenerProxy);
        }
        this.listeners.add(listener);
    }

    private IEditorReference getEditorReference() {
        return this.pane.getEditorReference();
    }

    public String getName() {
        WorkbenchPartReference ref = (WorkbenchPartReference)this.pane.getPartReference();
        return ref.getRegisteredName();
    }

    public String getTitle() {
        return this.getEditorReference().getTitle();
    }

    public Image getTitleImage() {
        return this.getEditorReference().getTitleImage();
    }

    public String getTitleToolTip() {
        return this.getEditorReference().getTitleToolTip();
    }

    public boolean isDirty() {
        return this.getEditorReference().isDirty();
    }

    public void removePropertyListener(IPropertyListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.getEditorReference().removePropertyListener(this.propertyListenerProxy);
        }
    }

    public void setBounds(Rectangle bounds) {
        this.pane.setBounds(bounds);
    }

    public void setFocus() {
        this.pane.setFocus();
    }

    public void setVisible(boolean isVisible) {
        this.pane.setVisible(isVisible);
    }

    public boolean isBusy() {
        return false;
    }

    public Control getToolBar() {
        return null;
    }

    public IPartMenu getMenu() {
        return null;
    }

    public Control getControl() {
        return this.pane.getControl();
    }
}

