/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.LayoutPartSash;
import org.eclipse.ui.internal.LayoutTree;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartSashContainer;

public class LayoutTreeNode
extends LayoutTree {
    private LayoutTree[] children = new LayoutTree[2];
    private static final int SASH_WIDTH = 3;

    public LayoutTreeNode(LayoutPartSash sash) {
        super(sash);
    }

    public LayoutPart findPart(Point toFind) {
        if (!this.children[0].isVisible()) {
            if (!this.children[1].isVisible()) {
                return null;
            }
            return this.children[1].findPart(toFind);
        }
        if (!this.children[1].isVisible()) {
            return this.children[0].findPart(toFind);
        }
        LayoutPartSash sash = this.getSash();
        Rectangle bounds = sash.getBounds();
        Geometry.getRelativePosition((Rectangle)bounds, (Point)toFind);
        if (sash.isVertical()) {
            if (toFind.x < bounds.x + bounds.width / 2) {
                return this.children[0].findPart(toFind);
            }
            return this.children[1].findPart(toFind);
        }
        if (toFind.y < bounds.y + bounds.height / 2) {
            return this.children[0].findPart(toFind);
        }
        return this.children[1].findPart(toFind);
    }

    public boolean fixedHeight() {
        return !(this.children[0].isVisible() && !this.children[0].fixedHeight() || this.children[1].isVisible() && !this.children[1].fixedHeight());
    }

    public LayoutPart computeRelation(ArrayList relations) {
        PartSashContainer.RelationshipInfo r = new PartSashContainer.RelationshipInfo();
        r.relative = this.children[0].computeRelation(relations);
        r.part = this.children[1].computeRelation(relations);
        r.ratio = this.getSash().getRatio();
        r.relationship = this.getSash().isVertical() ? 2 : 4;
        relations.add(0, r);
        return r.relative;
    }

    public void disposeSashes() {
        this.children[0].disposeSashes();
        this.children[1].disposeSashes();
        this.getSash().dispose();
    }

    public LayoutTree find(LayoutPart child) {
        LayoutTree node = this.children[0].find(child);
        if (node != null) {
            return node;
        }
        node = this.children[1].find(child);
        return node;
    }

    public LayoutPart findBottomRight() {
        if (this.children[1].isVisible()) {
            return this.children[1].findBottomRight();
        }
        return this.children[0].findBottomRight();
    }

    public LayoutTreeNode findCommonParent(LayoutPart child1, LayoutPart child2) {
        return this.findCommonParent(child1, child2, false, false);
    }

    LayoutTreeNode findCommonParent(LayoutPart child1, LayoutPart child2, boolean foundChild1, boolean foundChild2) {
        if (!foundChild1) {
            boolean bl = foundChild1 = this.find(child1) != null;
        }
        if (!foundChild2) {
            boolean bl = foundChild2 = this.find(child2) != null;
        }
        if (foundChild1 && foundChild2) {
            return this;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.findCommonParent(child1, child2, foundChild1, foundChild2);
    }

    public LayoutTreeNode findSash(LayoutPartSash sash) {
        if (this.getSash() == sash) {
            return this;
        }
        LayoutTreeNode node = this.children[0].findSash(sash);
        if (node != null) {
            return node;
        }
        node = this.children[1].findSash(sash);
        if (node != null) {
            return node;
        }
        return null;
    }

    void findSashes(LayoutTree child, PartPane.Sashes sashes) {
        boolean leftOrTop;
        Sash sash = (Sash)this.getSash().getControl();
        boolean bl = leftOrTop = this.children[0] == child;
        if (sash != null) {
            LayoutPartSash partSash = this.getSash();
            if (leftOrTop) {
                if (partSash.isVertical()) {
                    if (sashes.right == null) {
                        sashes.right = sash;
                    }
                } else if (sashes.bottom == null) {
                    sashes.bottom = sash;
                }
            } else if (partSash.isVertical()) {
                if (sashes.left == null) {
                    sashes.left = sash;
                }
            } else if (sashes.top == null) {
                sashes.top = sash;
            }
        }
        if (this.getParent() != null) {
            this.getParent().findSashes(this, sashes);
        }
    }

    public Rectangle getBounds() {
        if (!this.children[0].isVisible()) {
            return this.children[1].getBounds();
        }
        if (!this.children[1].isVisible()) {
            return this.children[0].getBounds();
        }
        Rectangle leftBounds = this.children[0].getBounds();
        Rectangle rightBounds = this.children[1].getBounds();
        Rectangle sashBounds = this.getSash().getBounds();
        Rectangle result = new Rectangle(leftBounds.x, leftBounds.y, leftBounds.width, leftBounds.height);
        if (this.getSash().isVertical()) {
            result.width = rightBounds.width + leftBounds.width + sashBounds.width;
            result.height = Math.max(leftBounds.height, rightBounds.height);
        } else {
            result.height = rightBounds.height + leftBounds.height + sashBounds.height;
            result.width = Math.max(leftBounds.width, rightBounds.width);
        }
        return result;
    }

    public LayoutPartSash getSash() {
        return (LayoutPartSash)this.part;
    }

    public boolean isVisible() {
        return this.children[0].isVisible() || this.children[1].isVisible();
    }

    public void recomputeRatio() {
        this.children[0].recomputeRatio();
        this.children[1].recomputeRatio();
        if (this.children[0].isVisible() && this.children[1].isVisible()) {
            if (this.getSash().isVertical()) {
                float left = this.children[0].getBounds().width;
                float right = this.children[1].getBounds().width;
                this.getSash().setRatio(left / (right + left + 3.0f));
            } else {
                float left = this.children[0].getBounds().height;
                float right = this.children[1].getBounds().height;
                this.getSash().setRatio(left / (right + left + 3.0f));
            }
        }
    }

    LayoutTree remove(LayoutTree child) {
        this.getSash().dispose();
        if (this.parent == null) {
            if (this.children[0] == child) {
                this.children[1].setParent(null);
                return this.children[1];
            }
            this.children[0].setParent(null);
            return this.children[0];
        }
        LayoutTreeNode oldParent = this.parent;
        if (this.children[0] == child) {
            oldParent.replaceChild(this, this.children[1]);
        } else {
            oldParent.replaceChild(this, this.children[0]);
        }
        return oldParent;
    }

    void replaceChild(LayoutTree oldChild, LayoutTree newChild) {
        if (this.children[0] == oldChild) {
            this.children[0] = newChild;
        } else if (this.children[1] == oldChild) {
            this.children[1] = newChild;
        }
        newChild.setParent(this);
        if (!this.children[0].isVisible() || !this.children[0].isVisible()) {
            this.getSash().dispose();
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean sameDirection(boolean isVertical, LayoutTreeNode subTree) {
        treeVertical = this.getSash().isVertical();
        if (treeVertical == isVertical) ** GOTO lbl9
        return false;
lbl-1000:
        // 1 sources

        {
            if (this == subTree) {
                return true;
            }
            if (subTree.children[0].isVisible() && subTree.children[1].isVisible() && subTree.getSash().isVertical() != isVertical) {
                return false;
            }
            subTree = subTree.getParent();
lbl9:
            // 2 sources

            ** while (subTree != null)
        }
lbl10:
        // 1 sources

        return true;
    }

    public void setBounds(Rectangle bounds) {
        if (!this.children[0].isVisible()) {
            this.children[1].setBounds(bounds);
            return;
        }
        if (!this.children[1].isVisible()) {
            this.children[0].setBounds(bounds);
            return;
        }
        Rectangle leftBounds = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
        Rectangle rightBounds = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
        Rectangle sashBounds = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
        float ratio = this.getSash().getRatio();
        if (this.getSash().isVertical()) {
            leftBounds.width = (int)(ratio * (float)bounds.width);
            sashBounds.x = leftBounds.x + leftBounds.width;
            sashBounds.width = 3;
            if (this.children[0].fixedHeight()) {
                leftBounds.height = this.children[0].getBounds().height;
            }
            rightBounds.x = sashBounds.x + sashBounds.width;
            rightBounds.width = bounds.width - leftBounds.width - sashBounds.width;
            if (this.children[1].fixedHeight()) {
                rightBounds.height = this.children[1].getBounds().height;
            }
            this.adjustWidths(bounds, leftBounds, rightBounds, sashBounds);
        } else {
            leftBounds.height = this.children[0].fixedHeight() ? this.children[0].getBounds().height : (this.children[1].fixedHeight() ? bounds.height - this.children[1].getBounds().height - 3 : (int)(ratio * (float)bounds.height));
            sashBounds.y = leftBounds.y + leftBounds.height;
            sashBounds.height = 3;
            rightBounds.y = sashBounds.y + sashBounds.height;
            rightBounds.height = this.children[1].fixedHeight() ? this.children[1].getBounds().height : bounds.height - leftBounds.height - sashBounds.height;
            this.adjustHeights(bounds, leftBounds, rightBounds, sashBounds);
        }
        this.getSash().setBounds(sashBounds);
        this.children[0].setBounds(leftBounds);
        this.children[1].setBounds(rightBounds);
    }

    private boolean adjustHeights(Rectangle node, Rectangle left, Rectangle right, Rectangle sash) {
        boolean adjusted;
        int leftAdjustment = 0;
        int rightAdjustment = 0;
        leftAdjustment = this.adjustChildHeight(left, node, true);
        if (leftAdjustment > 0) {
            right.height -= leftAdjustment;
        }
        if ((rightAdjustment = this.adjustChildHeight(right, node, false)) > 0) {
            left.height -= rightAdjustment;
        }
        boolean bl = adjusted = leftAdjustment > 0 || rightAdjustment > 0;
        if (adjusted) {
            sash.y = left.y + left.height;
            right.y = sash.y + sash.height;
        }
        return adjusted;
    }

    private int adjustChildHeight(Rectangle childBounds, Rectangle nodeBounds, boolean left) {
        int adjustment = 0;
        int minimum = 0;
        int n = minimum = left ? Math.round(this.getMinimumRatioFor(nodeBounds) * (float)nodeBounds.height) : Math.round((1.0f - this.getMaximumRatioFor(nodeBounds)) * (float)nodeBounds.height) - 3;
        if (minimum > childBounds.height) {
            adjustment = minimum - childBounds.height;
            childBounds.height = minimum;
        }
        return adjustment;
    }

    private boolean adjustWidths(Rectangle node, Rectangle left, Rectangle right, Rectangle sash) {
        boolean adjusted;
        int leftAdjustment = 0;
        int rightAdjustment = 0;
        leftAdjustment = this.adjustChildWidth(left, node, true);
        if (leftAdjustment > 0) {
            right.width -= leftAdjustment;
        }
        if ((rightAdjustment = this.adjustChildWidth(right, node, false)) > 0) {
            left.width -= rightAdjustment;
        }
        boolean bl = adjusted = leftAdjustment > 0 || rightAdjustment > 0;
        if (adjusted) {
            sash.x = left.x + left.width;
            right.x = sash.x + sash.width;
        }
        return adjusted;
    }

    private int adjustChildWidth(Rectangle childBounds, Rectangle nodeBounds, boolean left) {
        int adjustment = 0;
        int minimum = 0;
        int n = minimum = left ? Math.round(this.getMinimumRatioFor(nodeBounds) * (float)nodeBounds.width) : Math.round((1.0f - this.getMaximumRatioFor(nodeBounds)) * (float)nodeBounds.width) - 3;
        if (minimum > childBounds.width) {
            adjustment = minimum - childBounds.width;
            childBounds.width = minimum;
        }
        return adjustment;
    }

    public float getMinimumRatioFor(Rectangle bounds) {
        float part = 0.0f;
        float whole = 0.0f;
        if (this.getSash().isVertical()) {
            part = this.children[0].getMinimumWidth();
            whole = bounds.width;
        } else {
            part = this.children[0].getMinimumHeight();
            whole = bounds.height;
        }
        return part != 0.0f ? part / whole : 0.05f;
    }

    public float getMaximumRatioFor(Rectangle bounds) {
        float part = 0.0f;
        float whole = 0.0f;
        if (this.getSash().isVertical()) {
            whole = bounds.width;
            part = whole - (float)this.children[1].getMinimumWidth();
        } else {
            whole = bounds.height;
            part = whole - (float)this.children[1].getMinimumHeight();
        }
        return part != whole ? (part - 3.0f) / whole : 0.95f;
    }

    public int getMinimumHeight() {
        int left = this.children[0].getMinimumHeight();
        int right = this.children[1].getMinimumHeight();
        int minimum = 0;
        if (this.getSash().isVertical()) {
            minimum = Math.max(left, right);
        } else if (left > 0 || right > 0) {
            minimum = left + right;
            if (this.children[0].isVisible() && this.children[1].isVisible()) {
                minimum += 3;
            }
        }
        return minimum;
    }

    public int getMinimumWidth() {
        int left = this.children[0].getMinimumWidth();
        int right = this.children[1].getMinimumWidth();
        int minimum = 0;
        if (!this.getSash().isVertical()) {
            minimum = Math.max(left, right);
        } else if (left > 0 || right > 0) {
            minimum = left + right;
            if (this.children[0].isVisible() && this.children[1].isVisible()) {
                minimum += 3;
            }
        }
        return minimum;
    }

    void setChild(boolean left, LayoutPart part) {
        LayoutTree child = new LayoutTree(part);
        this.setChild(left, child);
    }

    void setChild(boolean left, LayoutTree child) {
        int index = left ? 0 : 1;
        this.children[index] = child;
        child.setParent(this);
    }

    public String toString() {
        String s = "<null>\n";
        if (this.part.getControl() != null) {
            s = "<@" + this.part.getControl().hashCode() + ">\n";
        }
        String result = "[";
        result = this.children[0].getParent() != this ? String.valueOf(result) + "{" + this.children[0] + "}" + s : String.valueOf(result) + this.children[0] + s;
        result = this.children[1].getParent() != this ? String.valueOf(result) + "{" + this.children[1] + "}]" : String.valueOf(result) + this.children[1] + "]";
        return result;
    }

    public void updateSashes(Composite parent) {
        if (parent == null) {
            return;
        }
        this.children[0].updateSashes(parent);
        this.children[1].updateSashes(parent);
        if (this.children[0].isVisible() && this.children[1].isVisible()) {
            this.getSash().createControl(parent);
        } else {
            this.getSash().dispose();
        }
    }
}

