import pygtk
pygtk.require('2.0')
import gtk
import error

class ValueMonitor(object):
    def __init__(self, current, timeout, notify, data):
        self._previous_value = current
        self._value = None
        self._timeout = timeout
        self._notify = notify
        self._data = data
        self._connected = True
        self._value_changed = False

    def get_value(self):
        return self._value

    def set_value(self, value):
        if self._connected:
            if value != self._value:
                self._value_changed = True
                gtk.timeout_add(self._timeout, self._check_value)
            self._value = value

    value = property(get_value, set_value)

    def connect(self):
        self._connected = True

    def disconnect(self):
        self.flush()
        self._connected = False

    def flush(self):
        self._check_value()

    def _check_value(self):
        if (self._connected and
            self._value_changed and
            self.value != self._previous_value):
            
            self._notify(self.value, self._data)
            self._previous_value = self.value

def create_for_gtkentry(widget, timeout, notify):
    vm = ValueMonitor(widget.get_text(), timeout, notify, widget)
    def changed(object, *data):
        vm.value = object.get_text()
    widget.connect("changed", changed)
    return vm

def create_for_gtkspin(widget, timeout, notify):
    vm = ValueMonitor(widget.get_value_as_int, timeout, notify, widget)
    def changed(object, *data):
        vm.value = object.get_value_as_int()
    widget.connect("value-changed", changed)
    return vm
