import gtk
import error

class MainloopManager:
    instance = None
    
    def __init__(self):
        self._idle_handlers = []
        self._call_depth = 0

    def add_idle_handler(self, handler):
        oid = self._add_idle(handler)
        self._idle_handlers.append((oid, handler))

    def _add_idle(self, handler):
        oid = gtk.idle_add(handler)
        return oid

    def remove_idle_handler(self, handler):
        for oid, h in self._idle_handlers:
            if h == handler:
                v = gtk.idle_remove(oid)
                break
        else:
            error.log("no handler ", handler, " found!")

    def remove_idle_handler_by_id(self, oid):
        gtk.idle_remove(oid)

    def call_pending(self):
        if self._call_depth > 0:
            error.log("Trying re-entry! Not allowed.")
            return
        self._call_depth += 1
        try:
            for oid, handler in self._idle_handlers:
                self.remove_idle_handler_by_id(oid)
            while gtk.events_pending():
                gtk.mainiteration(False)

            # if we depended on python 2.3, could use enumerate here instead
            for index in range(len(self._idle_handlers)):
                oid, handler = self._idle_handlers[index]
                new_id = self._add_idle(handler)
                self._idle_handlers[index] = (new_id, handler)
        finally:
            self._call_depth -= 1

    def get_instance(klass):
        if klass.instance is None:
            klass.instance = klass()
        return klass.instance
    get_instance = classmethod(get_instance)
