/* @(#)getpagesize.c	1.1 01/11/28 Copyright 2001 J. Schilling */
#ifndef lint
static	char sccsid[] =
	"@(#)getpagesize.c	1.1 01/11/28 Copyright 2001 J. Schilling";
#endif
/*
 *	Copyright (c) 2001 J. Schilling
 */
/*
 * Copyright Jrg Schilling. All rights reserved.
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only.
 * See the file CDDL.Schily.txt in this distribution or
 * http://opensource.org/licenses/cddl1.php for details.
 */

#include <mconfig.h>

#ifndef	HAVE_GETPAGESIZE
#include <unixstd.h>
#include <standard.h>
#ifdef	HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif
#include <libport.h>

#ifdef	HAVE_OS_H
#include <OS.h>		/* BeOS for B_PAGE_SIZE */
#endif

EXPORT	int	getpagesize	__PR((void));

EXPORT int
getpagesize()
{
	register int	pagesize;

#ifdef	_SC_PAGESIZE
	pagesize = sysconf(_SC_PAGESIZE);
#else	/* ! _SC_PAGESIZE */


#ifdef	PAGESIZE		/* Traditional UNIX page size from param.h */
	pagesize = PAGESIZE;

#else	/* ! PAGESIZE */

#ifdef	B_PAGE_SIZE		/* BeOS page size from OS.h */
	pagesize = B_PAGE_SIZE;

#else	/* ! B_PAGE_SIZE */

	pagesize = 512;
#endif	/* ! B_PAGE_SIZE */
#endif	/* ! PAGESIZE */
#endif	/* ! _SC_PAGESIZE */

	return (pagesize);
}

#endif	/* HAVE_GETPAGESIZE */
