/* SNAC
 * Copyright (C) 1999 the Free Software Foundation
 * Authors : Matias Mutchinick          
 *         
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <gnome.h>
#include "ag_defs.h"
#include "preferences.h"


////////////////////////////////////////////////////////////////////////////////
// START                                                                      //
// Of the definitions, declarations, and functions that compose the           //
// preferences editor                                                         //
////////////////////////////////////////////////////////////////////////////////




/* Declaration of the property box */
GtkWidget *agPropertyBox;

extern AgTextPref text_prefs;
extern AgModePref mode_prefs;

extern GtkWidget  *input_text, *output_text;


/*
 * ag_set_text_style
 */
void
ag_set_text_style()
{
	GtkStyle *style;
	
	style = gtk_style_copy(input_text->style);
	style->bg[GTK_STATE_NORMAL] = text_prefs.bg;
	style->base[GTK_STATE_NORMAL] = text_prefs.bg;
	gtk_widget_push_style(style);
	gtk_widget_set_style(input_text,style);
	gtk_widget_set_style(output_text,style);
	gtk_widget_pop_style();
}


void
ag_edit_preferences (GtkWidget        *widget, 
		     gpointer          data)
{
	
	GtkWidget      *generalPrefsBox;
	GtkWidget      *fgColorPicker;
	GtkWidget      *cuColorPicker;
	GtkWidget      *bgColorPicker;
	GtkWidget      *erColorPicker;
	GtkWidget      *fontPicker;
	
	
	static AgTextPref tmpprefs;	
	
	
       	
	tmpprefs.fg = text_prefs.fg;
	tmpprefs.er = text_prefs.er;
	tmpprefs.cu = text_prefs.cu;
	tmpprefs.bg = text_prefs.bg;
	strcpy(tmpprefs.fname,text_prefs.fname);
	
	
	
	agPropertyBox = gnome_property_box_new();
	GTK_WINDOW(agPropertyBox)->position = GTK_WIN_POS_MOUSE;
	gtk_window_set_title(GTK_WINDOW(agPropertyBox),
			     "SNAC Preferences Editor");
	
	gtk_signal_connect(GTK_OBJECT(agPropertyBox),"delete_event",
			   GTK_SIGNAL_FUNC(gtk_widget_destroy),
			   (gpointer) agPropertyBox);
		
	gtk_signal_connect(GTK_OBJECT(agPropertyBox),"apply",
			   GTK_SIGNAL_FUNC(ag_set_preferences),
			   &tmpprefs);
	
	generalPrefsBox = gtk_vbox_new(FALSE,5);
	gtk_container_set_border_width(GTK_CONTAINER(generalPrefsBox),10);
		
	gnome_property_box_append_page(GNOME_PROPERTY_BOX(agPropertyBox),
				       generalPrefsBox,
				       gtk_label_new("Text Preferences"));
		

	fgColorPicker = ag_color_picker_new("Foreground Color:",&tmpprefs.fg);
	gtk_box_pack_start_defaults(GTK_BOX(generalPrefsBox),fgColorPicker);
	
	bgColorPicker = ag_color_picker_new("Background Color:",&tmpprefs.bg);
	gtk_box_pack_start_defaults(GTK_BOX(generalPrefsBox),bgColorPicker);
	
	erColorPicker = ag_color_picker_new("Error Color:",&tmpprefs.er);
	gtk_box_pack_start_defaults(GTK_BOX(generalPrefsBox),erColorPicker);
	
	cuColorPicker = ag_color_picker_new("Cursor Color:",&tmpprefs.cu);
	gtk_box_pack_start_defaults(GTK_BOX(generalPrefsBox),cuColorPicker);
		
	fontPicker = ag_font_picker_new("Font:",&tmpprefs.fname[0]);
	gtk_box_pack_start_defaults(GTK_BOX(generalPrefsBox),fontPicker);
	
	
	gtk_widget_show_all(generalPrefsBox);
	gtk_widget_show(agPropertyBox);
	
	
	return;
}



/******************************************************************************/
/* ag_color_picker_new_with_label                                             */
/* create a box with a label and a colorpicker                                */
/* reference the color picker to one of the input_text colors                 */
/******************************************************************************/

GtkWidget *
ag_color_picker_new(gchar        *label,
		    GdkColor     *colordata)
{
	
	GtkWidget     *tableMain;
	GtkWidget     *colorPicker;
	GtkWidget     *colorPickerBox;
	GtkWidget     *labelWidget;
	GtkWidget     *labelWidgetBox;
	
	
	tableMain = gtk_table_new(1,10,TRUE);
	
	
	labelWidgetBox = gtk_hbox_new(FALSE,0);
	gtk_table_attach_defaults(GTK_TABLE(tableMain), labelWidgetBox,
				  0, 3, 0, 1);
	
	labelWidget = gtk_label_new(label);
	gtk_box_pack_end(GTK_BOX(labelWidgetBox),labelWidget,FALSE,TRUE,10);
	

	colorPickerBox = gtk_hbox_new(FALSE,0);
	gtk_table_attach_defaults(GTK_TABLE(tableMain),colorPickerBox,
				  3, 10, 0, 1);
	

	colorPicker = gnome_color_picker_new();
	gtk_signal_connect(GTK_OBJECT(colorPicker),"color-set",
			   GTK_SIGNAL_FUNC(ag_color_set),
			   (gpointer) colordata);
	
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(colorPicker),
				   colordata->red,
				   colordata->green,
				   colordata->blue,
				   0);
	

	gtk_box_pack_start(GTK_BOX(colorPickerBox),colorPicker,FALSE,TRUE,10);
	
	
	gtk_widget_show(colorPicker);
	gtk_widget_show(colorPickerBox);
	gtk_widget_show(labelWidget);
	gtk_widget_show(labelWidgetBox);
	

	return tableMain;
	
}



/******************************************************************************/
/* ag_font_picker_new_with_label                                              */
/* create a box with a label and a fontpicker                                 */
/* reference the font picker to the input_text font name                      */
/******************************************************************************/

GtkWidget *
ag_font_picker_new(gchar        *label,
		   gchar        *font)
{
	
	GtkWidget     *tableMain;
	GtkWidget     *fontPicker;
	GtkWidget     *fontPickerBox;
	GtkWidget     *labelWidget;
	GtkWidget     *labelWidgetBox;
	
		
	tableMain = gtk_table_new(1,10,TRUE);
	
	
	labelWidgetBox = gtk_hbox_new(FALSE,0);
	gtk_table_attach_defaults(GTK_TABLE(tableMain), labelWidgetBox,
				  0, 3, 0, 1);
	
	labelWidget = gtk_label_new(label);
	gtk_box_pack_end(GTK_BOX(labelWidgetBox),labelWidget,FALSE,TRUE,10);
	
	
	fontPickerBox = gtk_hbox_new(FALSE,0);
	gtk_table_attach_defaults(GTK_TABLE(tableMain), fontPickerBox,
				  3, 10, 0, 1);
	
	
	fontPicker = gnome_font_picker_new();
	gnome_font_picker_set_font_name(GNOME_FONT_PICKER(fontPicker),font);
	gnome_font_picker_set_mode(GNOME_FONT_PICKER(fontPicker),
				   GNOME_FONT_PICKER_MODE_FONT_INFO);
	
	gtk_signal_connect(GTK_OBJECT(fontPicker),"font-set",
			   GTK_SIGNAL_FUNC(ag_font_set),
			   (gpointer) font);
	
	
	gtk_box_pack_start(GTK_BOX(fontPickerBox),fontPicker,FALSE,TRUE,10);
	
	
	
	gtk_widget_show(fontPicker);
	gtk_widget_show(fontPickerBox);
	gtk_widget_show(labelWidget);
	gtk_widget_show(labelWidgetBox); 
	
	
	return tableMain;
}




/******************************************************************************/
/* ag_color_set                                                               */
/* this function is connected to a signal emited when a new color is set      */
/* in the color picker, it will store the new color in the temporary          */
/* preferences struct.                                                        */
/******************************************************************************/

void 
ag_color_set(GtkWidget        *cp,
	     guint             red,
	     guint             green,
	     guint             blue,
	     guint             alpha,
	     gpointer          data)
{

  
	GdkColor *colordata;
	
	colordata = (GdkColor *) data;
	
		
	colordata->red = red;
	colordata->green = green;
	colordata->blue = blue;
	
	
	gnome_property_box_changed(GNOME_PROPERTY_BOX(agPropertyBox));
	
	
	return;  
}




/******************************************************************************/
/* ag_font_set                                                                */
/* this function is connected to a signal emited when a new font is set       */
/* in the font picker, it will store the new font name in the temporary       */
/* preferences struct.                                                        */
/******************************************************************************/

void 
ag_font_set(GtkWidget        *fp,
	    gchar            *string, 
	    gpointer          data)
{
	
	gchar  * fntdata;
	

	fntdata = (gchar *) data;
	
	strcpy(fntdata,string);
	
	
	gnome_property_box_changed(GNOME_PROPERTY_BOX(agPropertyBox));
	
	
	return;  
}




/******************************************************************************/
/* ag_set_preferences                                                         */
/* set the new preferences from the temporary color struct active             */
/******************************************************************************/

void 
ag_set_preferences(GtkWidget      *widget,
		   gint            page,
		   gpointer        data)
{
	AgTextPref  *textpref;
	
	textpref = (AgTextPref *) data;
	
	text_prefs.fg = textpref->fg;
	text_prefs.er = textpref->er;
	text_prefs.cu = textpref->cu;
	text_prefs.bg = textpref->bg;
	
	strcpy(text_prefs.fname,textpref->fname);
	text_prefs.font = gdk_font_load(text_prefs.fname); 
	
	gnome_config_set_int("/SNAC/text/fg.red",text_prefs.fg.red);
	gnome_config_set_int("/SNAC/text/fg.green",text_prefs.fg.green);
	gnome_config_set_int("/SNAC/text/fg.blue",text_prefs.fg.blue);
	
	gnome_config_set_int("/SNAC/text/er.red",text_prefs.er.red);
	gnome_config_set_int("/SNAC/text/er.green",text_prefs.er.green);
	gnome_config_set_int("/SNAC/text/er.blue",text_prefs.er.blue);
	
	gnome_config_set_int("/SNAC/text/cu.red",text_prefs.cu.red);
	gnome_config_set_int("/SNAC/text/cu.green",text_prefs.cu.green);
	gnome_config_set_int("/SNAC/text/cu.blue",text_prefs.cu.blue);
	
	gnome_config_set_int("/SNAC/text/bg.red",text_prefs.bg.red);
	gnome_config_set_int("/SNAC/text/bg.green",text_prefs.bg.green);
	gnome_config_set_int("/SNAC/text/bg.blue",text_prefs.bg.blue);
	
	gnome_config_set_string("/SNAC/text/font",text_prefs.fname);
	
	
	gnome_config_sync();
	
	
	/* We need to rewrite the input_text .. */
	ag_set_text_style();
	
	return;
}




/******************************************************************************/
/* ag_get_preferences                                                         */
/* get the preferences from the config file                                   */
/******************************************************************************/

void 
ag_get_preferences()
{

	gchar     *str;
	
	text_prefs.fg.red = gnome_config_get_int("/SNAC/text/fg.red");
	text_prefs.fg.green = gnome_config_get_int("/SNAC/text/fg.green");
	text_prefs.fg.blue = gnome_config_get_int("/SNAC/text/fg.blue");
	
	text_prefs.er.red = gnome_config_get_int("/SNAC/text/er.red");
	text_prefs.er.green = gnome_config_get_int("/SNAC/text/er.green");
	text_prefs.er.blue = gnome_config_get_int("/SNAC/text/er.blue");
	
	text_prefs.cu.red = gnome_config_get_int("/SNAC/text/cu.red");
	text_prefs.cu.green = gnome_config_get_int("/SNAC/text/cu.green");
	text_prefs.cu.blue = gnome_config_get_int("/SNAC/text/cu.blue");
	
	text_prefs.bg.red = gnome_config_get_int("/SNAC/text/bg.red");
	text_prefs.bg.green = gnome_config_get_int("/SNAC/text/bg.green");
	text_prefs.bg.blue = gnome_config_get_int("/SNAC/text/bg.blue");
	
	if((str = gnome_config_get_string("/SNAC/text/font")) != NULL){
		strcpy(text_prefs.fname,str);
		g_free(str);
	} else
		strcpy(text_prefs.fname,"-misc-fixed-medium-r-*-*-*-120-*-*-*-*-*-*");
	
	text_prefs.font = gdk_font_load(text_prefs.fname);
		
	if((str = gnome_config_get_string("/SNAC/modes/size")) != NULL){
		strcpy(mode_prefs.size,str);
		g_free(str);
	}
	else
		strcpy(mode_prefs.size,"12");
	
	if((str = gnome_config_get_string("/SNAC/modes/angle")) != NULL){
		strcpy(mode_prefs.angle,str);
		g_free(str);
	}
	else
		strcpy(mode_prefs.angle,"Deg");
	
	if((str = gnome_config_get_string("/SNAC/modes/format")) != NULL){
		strcpy(mode_prefs.format,str);
		g_free(str);
	}
	else
		strcpy(mode_prefs.format,"Std");
	
}

