/*
 This file is part of slPIM.
 
 Copyright (c) 2001 John J. Ruthe <phaust@users.sourceforge.net>

 This program is free software; you can redistribute it and/or modify it
 under the terms of the GNU General Public License as published by the Free
 Software Foundation; either version 2 of the License, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 more details.

 You should have received a copy of the GNU General Public License along
 with this program; if not, write to the Free Software Foundation, Inc., 675
 Mass Ave, Cambridge, MA 02139, USA. 
*/

#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <dirent.h>
#include <errno.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <curses.h>
#include "defs.h"
#include "screen.h"

dyntab *ABOOK_FIELD_NAMES;

int slpim_do_config_colors(void) {
	/* normal color */
	NORM_COLOR = COLOR_PAIR(0);

	/* cursorbar color */
	init_pair(1, COLOR_WHITE, COLOR_GREEN);
	CURSORBAR_COLOR = COLOR_PAIR(1) | A_BOLD;

	/* statusbar color */
	init_pair(2, COLOR_YELLOW, COLOR_BLUE);
	STATUS_COLOR = COLOR_PAIR(2) | A_BOLD;

	/* info message color */
	init_pair(3, COLOR_YELLOW, COLOR_BLACK);
	MESSAGE_I_COLOR = COLOR_PAIR(3) | A_BOLD;

	/* warning message color */
	init_pair(4, COLOR_RED, COLOR_BLACK);
	MESSAGE_W_COLOR = COLOR_PAIR(4);

	/* error message color */
	init_pair(5, COLOR_BLACK, COLOR_RED);
	MESSAGE_E_COLOR = COLOR_PAIR(5);

	/* window's first line color */
	init_pair(6, COLOR_WHITE, COLOR_BLACK);
	AB_HEAD_COLOR = COLOR_PAIR(6) | A_BOLD;

	/* input line color */
	init_pair(7, COLOR_WHITE, COLOR_BLACK);
	INPUT_COLOR = COLOR_PAIR(7) | A_BOLD;

	return(0);
}

int slpim_do_config_fieldnames(void) {
	ABOOK_FIELD_NAMES = malloc(sizeof(dyntab));
	ABOOK_FIELD_NAMES->ent = malloc((256 + ABOOK_VIRT_FIELDS_NO) * sizeof(char*));
	ABOOK_FIELD_NAMES->i = ABOOK_FIELDS_NO;

	ABOOK_FIELD_NAMES->ent[FIELD_NAME] = "Name";
	ABOOK_FIELD_NAMES->ent[FIELD_FNAME] = "First Name";
	ABOOK_FIELD_NAMES->ent[FIELD_MNAME] = "Middle Name";
	ABOOK_FIELD_NAMES->ent[FIELD_LNAME] = "Last Name";
	ABOOK_FIELD_NAMES->ent[FIELD_NICK] = "Nickname";
	ABOOK_FIELD_NAMES->ent[FIELD_ORG] = "Organization";
	ABOOK_FIELD_NAMES->ent[FIELD_EMAIL] = "E-mail";
	ABOOK_FIELD_NAMES->ent[FIELD_URL] = "URL";
	ABOOK_FIELD_NAMES->ent[FIELD_NOTES] = "Notes";
	
	ABOOK_FIELD_NAMES->ent[FIELD_ADDR] = "Address";
	ABOOK_FIELD_NAMES->ent[FIELD_CITY] = "City";
	ABOOK_FIELD_NAMES->ent[FIELD_PCODE] = "ZIP/Postal code";
	ABOOK_FIELD_NAMES->ent[FIELD_STATE] = "State/Province";
	ABOOK_FIELD_NAMES->ent[FIELD_COUNTR] = "Country";

	ABOOK_FIELD_NAMES->ent[FIELD_PHHOME] = "Phone (Home)";
	ABOOK_FIELD_NAMES->ent[FIELD_PHWORK] = "Phone (Work)";
	ABOOK_FIELD_NAMES->ent[FIELD_PHFAX] = "Phone (Fax)";
	ABOOK_FIELD_NAMES->ent[FIELD_PHMOB] = "Phone (Mobile)";
	return(0);
}

int slpim_do_config_abfilename(void) {
	char *s, *t;
	DIR *d;
	int i;

	t = getenv("HOME");
	if(t) {
		s = malloc(strlen(t) + 17);
		strcpy(s, t);
		strcat(s, "/.slpim");
		d = opendir(s);
		if(d) {
			closedir(d);
		} else
			if(errno == ENOENT) {
				i = mkdir(s, 0700);
				if(i) {
					free(s);
					return(-1);
				}
			} else {
				free(s);
				return(-1);
			}
		
		strcat(s, "/database");
		slpim_ABASE_filename = s;
	} else
		slpim_ABASE_filename = "slpim.database";
	
	return(0);
}

int slpim_do_config(void) {
	slpim_do_config_fieldnames();
	if(!slpim_do_config_abfilename())
		return(0);
	return(-1);
}

int slpim_do_deconfig(void) {
	free(ABOOK_FIELD_NAMES->ent);
	free(ABOOK_FIELD_NAMES);
	return(0);
}

