package SliMP3::MusicFolderScan;

# SliMP3 Server Copyright (C) 2001 Sean Adams, Slim Devices Inc.
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License,
# version 2.

use strict;
use SliMP3::Misc;
# background scanning and cache prefilling of music information to speed up UI...

my @dummylist;
my $stillScanning;

sub startScan {
	my $savecache = shift;
	
	if (SliMP3::iTunes::useiTunesLibrary()) { 
		return;
	}

	if (SliMP3::MoodLogic::useMoodLogic()) { 
		return;
	}

	# Optionally don't clear the caches...
	if (!$savecache) {
		$::d_info && msg("Clearing ID3 cache\n");
		SliMP3::Info::clearCache();
	}

	if (!defined(SliMP3::Prefs::get("mp3dir")) or not -d SliMP3::Prefs::get("mp3dir")) {
		$::d_info && msg("Skipping pre-scan - mp3dir is undefined.\n");
		return 0;
	}

	if ($stillScanning) {
		$::d_info && msg("Scan already in progress. Aborting\n");
		SliMP3::Scan::stopAddToList(\@dummylist);
	}

	$stillScanning=1;
	SliMP3::Scan::addToList(\@dummylist, SliMP3::Prefs::get("mp3dir"), 1, 0, \&doneScanning, 0);
}

sub doneScanning {
	$::d_info && msg("finished background scan of music folder.\n");
	$stillScanning=0;
	@dummylist = ();
}

sub stillScanning {
	return $stillScanning;
}

1;
__END__

