/***************************************************
/
/ Title  : Test Program
/ Author : David Corcoran
/ Date   : 9/4/98
/ License: See LICENSE
/ Purpose: This is a test of the CT-API driver  It
/          resets the card and queries a random #.
/
****************************************************/

#include <stdio.h>
#include "ctapi.h"
#include "defines.h"

int main() {
  
  unsigned char dad=1;
  unsigned char sad=2;
  unsigned int lr = 3;
  BYTE Bcmd[50];
  BYTE Brsp[50];
  BYTE Brnd[5] = {0xC0,0x84,0x00,0x00,0x08};
  BYTE Act[5] = {0x20,0x12,0x00,0x00,0x00};
  BYTE Stat[5] = {0x20,0x13,0x00,0x00,0x00};
  BYTE Rst[5] = {0x20,0x11,0x00,0x00,0x00};
  BYTE Vfy[13] = {0xF0,0x2A,0x00,0x01,0x08,0x47,0x46,0x58,0x49,0x32,0x56,0x78,0x40};
  int i;
  int Iret;
  
  CT_init(1,PORT_COM1);
  
 while (1) {

  unsigned char dad=1;
  unsigned char sad=2;
  unsigned int lr = 3;

  if ((Iret = CT_data(1,&dad,&sad,5,Act,&lr,Brsp)) == OK ) {
    printf("Successfull Initialize \n");
  } else {
    printf("Error on Initialization -> %d\n", Iret);
  }

  dad = 1;   // Reader
  sad = 2;   // Host

  if ((Iret = CT_data(1,&dad,&sad,5,Rst,&lr,Brsp)) == OK ) {
    printf("Successfull Reset/Set Mode \n");
  } else {
    printf("Error on Reset -> %d\n", Iret);
  }
  
  lr = 8;
  dad = 0;
  sad = 2;

  if ((Iret = CT_data(1,&dad,&sad,5,Brnd,&lr,Brsp)) == OK ) {
    printf("Successfull Get Challenge\n");
  } else {
    printf("Error on Get Challenge -> %d\n", Iret);
  }

 
 printf("Response Size: %x \n", lr);
 
 for (i=0; i<lr; i++) {
   printf("%x ", Brsp[i]);
 }
 
 printf("\n");


  lr = 8;
  dad = 0;
  sad = 2;

  if ((Iret = CT_data(1,&dad,&sad,13,Vfy,&lr,Brsp)) == OK ) {
    printf("Successfull\n");
    printf("Verify Status: %x %x\n", Brsp[0], Brsp[1]);
 
  } else {
    printf("Error on Verify Key -> %d\n", Iret);
  }

  sleep (1);

  }

 CT_close(1);
 
}
